// Written by Christopher E. Miller
// This code is public domain.

// This module gives a brief description for the most
// common/important error codes for common dialogs.


private import std.string;


class CdErr: Exception
{
	public uint code = 0;
	
	
	static char[] errorString(uint code)
	{
		char[] s;
		
		switch(code)
		{
			case 0x0001: //CDERR_STRUCTSIZE
				s = "Invalid structure size.";
				break;
			
			case 0x0002: //CDERR_INITIALIZATION
				s = "Initialization failure.";
				break;
			
			case 0x0006: //CDERR_FINDRESFAILURE
			case 0x0007: //CDERR_LOADRESFAILURE
			case 0x0008: //CDERR_LOCKRESFAILURE
				s = "Unable to load all items.";
				break;
			
			case 0x0009: //CDERR_MEMALLOCFAILURE
			case 0x000A: //CDERR_MEMLOCKFAILURE
				s = "Memory error.";
				break;
			
			default:
				s = "Error " ~ std.string.toString(code);
		}
		
		return s;
	}
	
	
	char[] toString()
	{
		return msg;
	}
	
	
	this(uint errorCode)
	{
		code = errorCode;
		super(errorString(errorCode));
	}
	
	
	this(char[] msg)
	{
		super(msg); // Custom message.
	}
}


class OpenFileNameDlgErr: CdErr
{
	static char[] errorString(uint code)
	{
		char[] s;
		
		switch(code)
		{
			case 0x3003: //FNERR_BUFFERTOOSMALL
				s = "Buffer too small.";
				break;
			
			case 0x3002: //FNERR_INVALIDFILENAME
				s = "Invalid file name.";
				break;
			
			default:
				s = CdErr.errorString(code);
		}
		
		return s;
	}
	
	
	char[] toString()
	{
		return msg;
	}
	
	
	this(char[] msg)
	{
		super(msg);
	}
	
	
	this(uint errorCode)
	{
		code = errorCode;
		super(errorString(errorCode));
	}
}

