private import dfl.all;


class ComboForm: Form
{
	ComboBox cbox;
	Button okBtn;
	
	this()
	{
		initializeComboForm();
		
		with(cbox = new ComboBox)
		{
			font = new Font("Tahoma", 9);
			text = "Select a Month";
			width = 120;
			items.add("January");
			items.add("February");
			items.add("March");
			items.add("April");
			items.add("May");
			items.add("June");
			items.add("July");
			items.add("August");
			items.add("September");
			items.add("October");
			items.add("November");
			items.add("December");
			
			parent = this;
		}
		
		with(okBtn = new Button)
		{
			text = "OK";
			left = cbox.right + 4;
			
			parent = this;
			
			click ~= &onOkClick;
		}
		
		acceptButton = okBtn;
	}
	
	
	private void onOkClick(Object sender, EventArgs ea)
	{
		Object selItem;
		selItem = cbox.selectedItem;
		
		if(selItem)
		{
			msgBox(selItem.toString(), "Month",
				MsgBoxButtons.OK, MsgBoxIcon.INFORMATION);
		}
		else
		{
			msgBox("Please select a month first.", "Oops",
				MsgBoxButtons.OK, MsgBoxIcon.INFORMATION);
		}
	}
	
	
	private void initializeComboForm()
	{
		// Do not manually edit this block of code.
		//~DFL Designer 0.3 code begins here.
		
		//~DFL MainForm
		startPosition = FormStartPosition.CENTER_SCREEN;
		text = "DFL Combo Box Example";
		clientSize = dfl.drawing.Size(292, 273);
		location = dfl.drawing.Point(0, 0);
		
		//~DFL Designer 0.3 code ends here.
	}
}


int main()
{
	int result = 0;
	
	try
	{
		Application.enableVisualStyles();
		
		Application.run(new ComboForm);
	}
	catch(DflThrowable o)
	{
		msgBox(o.toString(), "Fatal Error", MsgBoxButtons.OK, MsgBoxIcon.ERROR);
		
		result = 1;
	}
	
	return result;
}

