// This module just contains things that are needed but aren't in std.c.windows.windows.
// This code is public domain.

module dfl.internal.winapi;


version(Tango)
{
	version(Tangobos)
		version = HASstdcwindowswindows;
}
else
{
	version = HASstdcwindowswindows;
}


/+
version(Tango)
{
	/+
	public import tango.sys.win32.Macros;
	//public import tango.sys.win32.Process;
	public import tango.sys.win32.Types;
	public import tango.sys.win32.UserGdi;
	+/
}
+/



version(HASstdcwindowswindows)
{
	public import std.c.windows.windows;
}
else
{
	public import dfl.internal._stdcwindows;
}
private import dfl.internal.wincom;


version(D_Version2)
{
	version = DFL_D2;
	version = DFL_D2_AND_ABOVE;
}
else version(D_Version3)
{
	version = DFL_D3;
	version = DFL_D3_AND_ABOVE;
	version = DFL_D2_AND_ABOVE;
}
else version(D_Version4)
{
	version = DFL_D4;
	version = DFL_D4_AND_ABOVE;
	version = DFL_D3_AND_ABOVE;
	version = DFL_D2_AND_ABOVE;
}
else
{
	version = DFL_D1;
}
//version = DFL_D1_AND_ABOVE;


extern(Windows):
	
	struct SIZE
	{
		LONG cx;
		LONG cy;
	}
	alias SIZE* LPSIZE;
	
	
	struct POINTL
	{
		LONG x;
		LONG y;
	}
	alias POINTL* LPPOINTL;
	
	
	alias RECT* LPCRECT;
	
	
	alias WORD LANGID;
	
	
	alias size_t ULONG_PTR;
	
	
	alias long LONGLONG;
	
	alias ulong DWORDLONG;
	
	
	alias HRESULT THEMEAPI;
	
	
	union LARGE_INTEGER
	{
		struct
		{
			DWORD LowPart;
			LONG HighPart;
		}
		private struct _U
		{
			DWORD LowPart;
			LONG HighPart;
		}
		_U u;
		LONGLONG QuadPart;
	}
	
	
	union ULARGE_INTEGER
	{
		struct
		{
			DWORD LowPart;
			DWORD HighPart;
		}
		private struct _U
		{
			DWORD LowPart;
			DWORD HighPart;
		}
		_U u;
		DWORDLONG QuadPart;
	}
	
	
	enum: UINT
	{
		SWP_NOSIZE = 0x0001,
		SWP_NOMOVE = 0x0002,
		SWP_NOZORDER = 0x0004,
		SWP_NOREDRAW = 0x0008,
		SWP_NOACTIVATE = 0x0010,
		SWP_FRAMECHANGED = 0x0020,
		SWP_SHOWWINDOW = 0x0040,
		SWP_HIDEWINDOW = 0x0080,
		SWP_NOCOPYBITS = 0x0100,
		SWP_NOOWNERZORDER = 0x0200,
		SWP_NOSENDCHANGING = 0x0400,
		SWP_DRAWFRAME = SWP_FRAMECHANGED,
		SWP_NOREPOSITION = SWP_NOOWNERZORDER,
		SWP_DEFERERASE = 0x2000,
		SWP_ASYNCWINDOWPOS = 0x4000,
	}
	
	
	enum: UINT
	{
		GW_HWNDFIRST = 0,
		GW_HWNDLAST = 1,
		GW_HWNDNEXT = 2,
		GW_HWNDPREV = 3,
		GW_OWNER = 4,
		GW_CHILD = 5,
	}
	
	
	enum: UINT
	{
		DI_MASK = 0x0001,
		DI_IMAGE = 0x0002,
		DI_COMPAT = 0x0004,
		DI_DEFAULTSIZE = 0x0008,
		DI_NORMAL = DI_IMAGE | DI_MASK,
	}
	
	
	enum: int
	{
		GCL_MENUNAME = -8,
		GCL_HBRBACKGROUND = -10,
		GCL_HCURSOR = -12,
		GCL_HICON = -14,
		GCL_HMODULE = -16,
		GCL_CBWNDEXTRA = -18,
		GCL_CBCLSEXTRA = -20,
		GCL_WNDPROC = -24,
		GCL_STYLE = -26,
		GCW_ATOM = -32,
		GCL_HICONSM = -34,
	}
	
	
	enum: UINT
	{
		SC_SIZE = 0xF000,
		SC_MOVE = 0xF010,
		SC_MINIMIZE = 0xF020,
		SC_MAXIMIZE = 0xF030,
		SC_CLOSE = 0xF060,
		SC_VSCROLL = 0xF070,
		SC_HSCROLL = 0xF080,
		SC_RESTORE = 0xF120,
		SC_SEPARATOR = 0xF00F,
	}
	
	
	enum: int
	{
		GWL_WNDPROC = -4,
		GWL_HINSTANCE = -6,
		GWL_HWNDPARENT = -8,
		GWL_STYLE = -16,
		GWL_EXSTYLE = -20,
		GWL_USERDATA = -21,
		GWL_ID = -12,
		
		DWL_MSGRESULT = 0,
		DWL_DLGPROC = 4,
		DWL_USER = 8,
	}
	
	
	enum: UINT
	{
		WM_SETFONT = 0x0030,
		WM_GETFONT = 0x0031,
		WM_COMPACTING = 0x0041,
		WM_USER = 0x0400,
		WM_NEXTDLGCTL = 0x0028,
		WM_CAPTURECHANGED = 0x0215,
		WM_WINDOWPOSCHANGING = 0x0046,
		WM_WINDOWPOSCHANGED = 0x0047,
		WM_DRAWITEM = 0x002B,
		WM_DROPFILES = 0x0233,
		WM_PALETTECHANGED = 0x0311,
		
		WM_CLEAR = 0x0303,
		
		WM_CUT = 0x0300,
		WM_COPY = 0x0301,
		WM_PASTE = 0x0302,
		
		WM_MDIACTIVATE = 0x0222,
		WM_MDITILE = 0x0226,
		WM_MDICASCADE = 0x0227,
		WM_MDIICONARRANGE = 0x0228,
		WM_MDIGETACTIVE = 0x0229,
		
		WM_MOUSEWHEEL = 0x020A,
		WM_MOUSEHOVER = 0x02A1,
		WM_MOUSELEAVE = 0x02A3,
		
		
		WM_PRINT = 0x0317,
		WM_PRINTCLIENT = 0x0318,
		
		WM_MEASUREITEM = 0x002C,
		
		DM_SETDEFID = WM_USER + 1,
	}
	
	
	enum: UINT
	{
		BFFM_INITIALIZED = 1,
		BFFM_SETSELECTIONA = WM_USER + 102,
		BFFM_SETSELECTIONW = WM_USER + 103,
	}
	
	
	enum: UINT
	{
		NM_FIRST = 0,
		NM_CLICK = NM_FIRST - 2,
		NM_CUSTOMDRAW = NM_FIRST - 12,
	}
	
	
	struct NMMOUSE
	{
		NMHDR hdr;
		DWORD dwItemSpec;
		DWORD dwItemData;
		POINT pt;
		LPARAM dwHitInfo;
	}
	alias NMMOUSE* LPNMMOUSE;
	
	
	enum: UINT
	{
		TTM_ACTIVATE = WM_USER + 1,
		TTM_SETDELAYTIME = WM_USER + 3,
		TTM_ADDTOOLA = WM_USER + 4,
		TTM_DELTOOLA = WM_USER + 5,
		TTM_GETTOOLINFOA = WM_USER + 8,
		TTM_GETTEXTA = WM_USER + 11,
		TTM_UPDATETIPTEXTA = WM_USER + 12,
		TTM_ENUMTOOLSA = WM_USER + 14,
		TTM_GETCURRENTTOOLA = WM_USER + 15,
		TTM_ADDTOOLW = WM_USER + 50,
		TTM_GETTEXTW = WM_USER + 56,
		TTM_UPDATETIPTEXTW = WM_USER + 57,
	}
	
	
	enum: WPARAM
	{
		TTDT_AUTOMATIC = 0,
		TTDT_RESHOW = 1,
		TTDT_AUTOPOP = 2,
		TTDT_INITIAL = 3,
	}
	
	
	// Rich edit.
	enum: UINT
	{
		ES_DISABLENOSCROLL = 0x00002000,
		
		EM_CANPASTE = WM_USER + 50,
		EM_EXGETSEL = WM_USER + 52,
		EM_EXLIMITTEXT = WM_USER + 53,
		EM_EXLINEFROMCHAR = WM_USER + 54,
		EM_EXSETSEL = WM_USER + 55,
		EM_GETCHARFORMAT = WM_USER + 58,
		EM_GETSELTEXT = WM_USER + 62,
		EM_PASTESPECIAL = WM_USER + 64,
		EM_SETBKGNDCOLOR = WM_USER + 67,
		EM_SETCHARFORMAT = WM_USER + 68,
		EM_SETEVENTMASK = WM_USER + 69,
		EM_STREAMIN = WM_USER + 73,
		EM_STREAMOUT = WM_USER + 74,
		EM_GETTEXTRANGE = WM_USER + 75,
		
		// 2.0
		EM_SETUNDOLIMIT = WM_USER + 82,
		EM_REDO = WM_USER + 84,
		EM_CANREDO = WM_USER + 85,
		EM_GETUNDONAME = WM_USER + 86,
		EM_GETREDONAME = WM_USER + 87,
		EM_STOPGROUPTYPING = WM_USER + 88,
		EM_SETTEXTMODE = WM_USER + 89,
		EM_GETTEXTMODE = WM_USER + 90,
		
		EM_AUTOURLDETECT = WM_USER + 91,
		EM_GETAUTOURLDETECT = WM_USER + 92,
		EM_SETPALETTE = WM_USER + 93,
		EM_GETTEXTEX = WM_USER + 94,
		EM_GETTEXTLENGTHEX = WM_USER + 95,
		EM_SHOWSCROLLBAR = WM_USER + 96,
		EM_SETTEXTEX = WM_USER + 97,
		
		EN_LINK = 0x070B,
	}
	
	
	// Rich edit.
	enum: UINT
	{
		SF_TEXT = 0x0001,
		SF_RTF = 0x0002,
		SF_RTFNOOBJS = 0x0003,
		SF_TEXTIZED = 0x0004,
		
		SFF_SELECTION = 0x8000,
		SFF_PLAINRTF = 0x4000,
		
		SCF_SELECTION = 0x0001,
		SCF_WORD = 0x0002,
		SCF_ALL = 0x0004,
		
		CFM_BOLD = 0x00000001,
		CFM_ITALIC = 0x00000002,
		CFM_UNDERLINE = 0x00000004,
		CFM_STRIKEOUT = 0x00000008,
		CFM_PROTECTED = 0x00000010,
		CFM_LINK = 0x00000020,
		CFM_SIZE = 0x80000000,
		CFM_COLOR = 0x40000000,
		CFM_FACE = 0x20000000,
		CFM_OFFSET = 0x10000000,
		CFM_CHARSET = 0x08000000,
		CFM_SMALLCAPS = 0x0040,
		CFM_ALLCAPS = 0x0080,
		CFM_HIDDEN = 0x0100,
		CFM_OUTLINE = 0x0200,
		CFM_SHADOW = 0x0400,
		CFM_EMBOSS = 0x0800,
		CFM_IMPRINT = 0x1000,
		CFM_DISABLED = 0x2000,
		CFM_REVISED = 0x4000,
		CFM_BACKCOLOR = 0x04000000,
		CFM_LCID = 0x02000000,
		CFM_UNDERLINETYPE = 0x00800000,
		CFM_WEIGHT = 0x00400000,
		CFM_SPACING = 0x00200000,
		CFM_KERNING = 0x00100000,
		CFM_STYLE = 0x00080000,
		CFM_ANIMATION = 0x00040000,
		CFM_REVAUTHOR = 0x00008000,
		
		CFE_BOLD = 0x0001,
		CFE_ITALIC = 0x0002,
		CFE_UNDERLINE = 0x0004,
		CFE_STRIKEOUT = 0x0008,
		CFE_PROTECTED = 0x0010,
		CFE_LINK = 0x0020,
		CFE_AUTOCOLOR = 0x40000000,
		CFE_AUTOBACKCOLOR	= CFM_BACKCOLOR,
		CFE_SUBSCRIPT = 0x00010000,
		CFE_SUPERSCRIPT = 0x00020000,
		
		CFM_SUBSCRIPT = CFE_SUBSCRIPT | CFE_SUPERSCRIPT,
		CFM_SUPERSCRIPT = CFM_SUBSCRIPT,
		
		CFU_UNDERLINE = 1,
		
		ENM_NONE = 0x00000000,
		ENM_CHANGE = 0x00000001,
		ENM_UPDATE = 0x00000002,
		ENM_LINK = 0x04000000,
		ENM_PROTECTED = 0x00200000,
	}
	
	
	enum: DWORD
	{
		PRF_CLIENT = 0x00000004,
	}
	
	
	enum: DWORD
	{
		STAP_ALLOW_NONCLIENT = 0x00000001,
		STAP_ALLOW_CONTROLS = 0x00000002,
		STAP_ALLOW_WEBCONTENT = 0x00000004,
	}
	
	
	enum: LPARAM
	{
		ENDSESSION_LOGOFF = 0x80000000,
	}
	
	
	enum: int
	{
		BLACKONWHITE = 1,
		WHITEONBLACK = 2,
		COLORONCOLOR = 3,
		HALFTONE = 4,
	}
	
	
	enum: UINT
	{
		CDN_FIRST = cast(UINT)-601,
		CDN_LAST = cast(UINT)-699,
		CDN_INITDONE = CDN_FIRST - 0x0000,
		CDN_SELCHANGE = CDN_FIRST - 0x0001,
		CDN_FOLDERCHANGE = CDN_FIRST - 0x0002,
		CDN_SHAREVIOLATION = CDN_FIRST - 0x0003,
		CDN_HELP = CDN_FIRST - 0x0004,
		CDN_FILEOK = CDN_FIRST - 0x0005,
		CDN_TYPECHANGE = CDN_FIRST - 0x0006,
		CDN_INCLUDEITEM = CDN_FIRST - 0x0007,
	}
	
	
	enum: DWORD
	{
		OFN_READONLY = 0x00000001,
		OFN_OVERWRITEPROMPT = 0x00000002,
		OFN_HIDEREADONLY = 0x00000004,
		OFN_NOCHANGEDIR = 0x00000008,
		OFN_SHOWHELP = 0x00000010,
		OFN_ENABLEHOOK = 0x00000020,
		OFN_ENABLETEMPLATE = 0x00000040,
		OFN_ENABLETEMPLATEHANDLE = 0x00000080,
		OFN_NOVALIDATE = 0x00000100,
		OFN_ALLOWMULTISELECT = 0x00000200,
		OFN_EXTENSIONDIFFERENT = 0x00000400,
		OFN_PATHMUSTEXIST = 0x00000800,
		OFN_FILEMUSTEXIST = 0x00001000,
		OFN_CREATEPROMPT = 0x00002000,
		OFN_SHAREAWARE = 0x00004000,
		OFN_NOREADONLYRETURN = 0x00008000,
		OFN_NOTESTFILECREATE = 0x00010000,
		OFN_NONETWORKBUTTON = 0x00020000,
		OFN_NOLONGNAMES = 0x00040000,
		OFN_EXPLORER = 0x00080000,
		OFN_NODEREFERENCELINKS = 0x00100000,
		OFN_LONGNAMES = 0x00200000,
		OFN_ENABLEINCLUDENOTIFY = 0x00400000,
		OFN_ENABLESIZING = 0x00800000,
		OFN_DONTADDTORECENT = 0x02000000,
		OFN_FORCESHOWHIDDEN = 0x10000000,
	}
	
	
	enum: DWORD
	{
		CF_SCREENFONTS = 0x00000001,
		CF_PRINTERFONTS = 0x00000002,
		CF_BOTH = CF_SCREENFONTS | CF_PRINTERFONTS,
		CF_SHOWHELP = 0x00000004,
		CF_ENABLEHOOK = 0x00000008,
		CF_ENABLETEMPLATE = 0x00000010,
		CF_ENABLETEMPLATEHANDLE = 0x00000020,
		CF_INITTOLOGFONTSTRUCT = 0x00000040,
		CF_USESTYLE = 0x00000080,
		CF_EFFECTS = 0x00000100,
		CF_APPLY = 0x00000200,
		CF_ANSIONLY = 0x00000400,
		CF_SCRIPTSONLY = CF_ANSIONLY,
		CF_NOVECTORFONTS = 0x00000800,
		CF_NOOEMFONTS = CF_NOVECTORFONTS,
		CF_NOSIMULATIONS = 0x00001000,
		CF_LIMITSIZE = 0x00002000,
		CF_FIXEDPITCHONLY = 0x00004000,
		CF_WYSIWYG = 0x00008000,
		CF_FORCEFONTEXIST = 0x00010000,
		CF_SCALABLEONLY = 0x00020000,
		CF_TTONLY = 0x00040000,
		CF_NOFACESEL = 0x00080000,
		CF_NOSTYLESEL = 0x00100000,
		CF_NOSIZESEL = 0x00200000,
		CF_SELECTSCRIPT = 0x00400000,
		CF_NOSCRIPTSEL = 0x00800000,
		CF_NOVERTFONTS = 0x01000000,
	}
	
	
	enum: UINT
	{
		ODT_MENU = 1,
		ODT_LISTBOX = 2,
		ODT_COMBOBOX = 3,
		ODT_BUTTON = 4,
		ODT_STATIC = 5,
	}
	
	
	enum: int
	{
		HC_ACTION = 0,
	}
	
	
	enum: int
	{
		WH_GETMESSAGE = 3,
		WH_CALLWNDPROC = 4,
		WH_CALLWNDPROCRET = 12,
	}
	
	
	struct CWPSTRUCT
	{
		LPARAM lParam;
		WPARAM wParam;
		UINT message;
		HWND hwnd;
	}
	alias CWPSTRUCT* LPCWPSTRUCT;
	
	
	struct CWPRETSTRUCT
	{
		LRESULT lResult;
		LPARAM lParam;
		WPARAM wParam;
		DWORD message;
		HWND hwnd;
	}
	alias CWPRETSTRUCT* LPCWPRETSTRUCT;
	
	
	enum: UINT
	{
		MDITILE_VERTICAL = 0x0000,
		MDITILE_HORIZONTAL = 0x0001,
		MDITILE_SKIPDISABLED = 0x0002,
		MDITILE_ZORDER = 0x0004,
	}
	
	
	enum: DWORD
	{
		WS_EX_NOPARENTNOTIFY = 0x00000004,
		WS_EX_ACCEPTFILES = 0x00000010,
		WS_EX_TRANSPARENT = 0x00000020,
		WS_EX_RTLREADING = 0x00002000,
		WS_EX_APPWINDOW = 0x00040000,
		WS_EX_DLGMODALFRAME = 0x00000001,
		WS_EX_CONTROLPARENT = 0x00010000,
		WS_EX_WINDOWEDGE = 0x00000100,
		WS_EX_CLIENTEDGE = 0x00000200,
		WS_EX_TOOLWINDOW = 0x00000080,
		WS_EX_STATICEDGE = 0x00020000,
		WS_EX_CONTEXTHELP = 0x00000400,
		WS_EX_MDICHILD = 0x00000040,
		WS_EX_LAYERED = 0x00080000,
		WS_EX_TOPMOST = 0x00000008,
	}
	
	
	enum: DWORD
	{
		TTS_ALWAYSTIP = 0x01,
		TTS_NOPREFIX = 0x02,
		TTS_NOANIMATE = 0x10, // IE5+
		TTS_NOFADE = 0x20, // IE5+
		TTS_BALLOON = 0x40, // IE5+
	}
	
	
	enum
	{
		TTF_IDISHWND = 0x0001,
		TTF_CENTERTIP = 0x0002,
		TTF_RTLREADING = 0x0004,
		TTF_SUBCLASS = 0x0010,
		TTF_TRACK = 0x0020, // IE3+
		TTF_ABSOLUTE = 0x0080, // IE3+
		TTF_TRANSPARENT = 0x0100, // IE3+
		TTF_DI_SETITEM = 0x8000, // IE3+
	}
	
	
	enum: WPARAM
	{
		SIZE_RESTORED = 0,
		SIZE_MINIMIZED = 1,
		SIZE_MAXIMIZED = 2,
		SIZE_MAXSHOW = 3,
		SIZE_MAXHIDE = 4,
	}
	
	
	enum: DWORD
	{
		LWA_COLORKEY = 1,
		LWA_ALPHA = 2,
		
		AW_HOR_POSITIVE = 0x00000001,
		AW_HOR_NEGATIVE = 0x00000002,
		AW_VER_POSITIVE = 0x00000004,
		AW_VER_NEGATIVE = 0x00000008,
		AW_CENTER = 0x00000010,
		AW_HIDE = 0x00010000,
		AW_ACTIVATE = 0x00020000,
		AW_SLIDE = 0x00040000,
		AW_BLEND = 0x00080000,
	}
	
	
	enum: UINT
	{
		MF_STRING = 0x00000000,
		MF_UNCHECKED = 0x00000000,
		MF_BYCOMMAND = 0x00000000,
		MF_GRAYED = 0x00000001,
		MF_CHECKED = 0x00000008,
		MF_POPUP = 0x00000010,
		MF_MENUBARBREAK = 0x00000020,
		MF_MENUBREAK = 0x00000040,
		MF_BYPOSITION = 0x00000400,
		MF_SEPARATOR = 0x00000800,
		MF_DEFAULT = 0x00001000,
		MF_SYSMENU = 0x00002000,
		
		MFT_STRING = MF_STRING,
		MFT_MENUBARBREAK = MF_MENUBARBREAK,
		MFT_MENUBREAK = MF_MENUBREAK,
		MFT_RADIOCHECK = 0x00000200,
		MFT_SEPARATOR = MF_SEPARATOR,
		
		MFS_UNCHECKED = MF_UNCHECKED,
		MFS_CHECKED = MF_CHECKED,
		MFS_DEFAULT = MF_DEFAULT,
		MFS_GRAYED = MF_GRAYED,
		
		MIIM_STATE = 0x00000001,
		MIIM_ID = 0x00000002,
		MIIM_SUBMENU = 0x00000004,
		MIIM_TYPE = 0x00000010,
	}
	
	
	enum: int
	{
		RGN_AND = 1,
		RGN_OR = 2,
		RGN_XOR = 3,
		RGN_DIFF = 4,
		RGN_COPY = 5,
	}
	
	
	//alias UINT CLIPFORMAT; // ?
	alias WORD CLIPFORMAT; // ?
	
	
	// enum can't derive from HWND.
	const HWND HWND_TOP = cast(HWND)0;
	const HWND HWND_BOTTOM = cast(HWND)1;
	const HWND HWND_TOPMOST = cast(HWND)-1;
	const HWND HWND_NOTOPMOST = cast(HWND)-2;
	
	
	enum: UINT
	{
		BS_SOLID = 0,
		BS_GROUPBOX = 0x00000007,
	}
	
	
	enum: UINT
	{
		CBS_SIMPLE = 0x0001,
		CBS_DROPDOWN = 0x0002,
		CBS_DROPDOWNLIST = 0x0003,
		CBS_AUTOHSCROLL = 0x0040,
		CBS_OWNERDRAWFIXED = 0x0010,
		CBS_OWNERDRAWVARIABLE = 0x0020,
	}
	
	
	enum: DWORD
	{
		TME_HOVER =   1,
		TME_LEAVE =   2,
		TME_QUERY =   0x40000000,
		TME_CANCEL =  0x80000000,
	}
	
	
	const DWORD HOVER_DEFAULT = 0xFFFFFFFF;
	
	
	enum: UINT
	{
		TPM_LEFTBUTTON = 0x0000,
		TPM_RIGHTBUTTON = 0x0002,
		TPM_LEFTALIGN = 0x0000,
		TPM_CENTERALIGN = 0x0004,
		TPM_RIGHTALIGN = 0x0008,
		TPM_TOPALIGN = 0x0000,
		TPM_VCENTERALIGN = 0x0010,
		TPM_BOTTOMALIGN = 0x0020,
		TPM_HORIZONTAL = 0x0000,
		TPM_VERTICAL = 0x0040,
		TPM_NONOTIFY = 0x0080,
		TPM_RETURNCMD = 0x0100,
		TPM_RECURSE = 0x0001,
	}
	
	
	enum
	{
		ICON_SMALL = 0,
		ICON_BIG = 1,
	}
	
	
	enum
	{
		WAIT_TIMEOUT = 258,
	}
	
	
	enum: DWORD
	{
		INFINITE = 0xFFFFFFFF,
		IGNORE = 0,
		WAIT_FAILED = 0xFFFFFFFF,
		STATUS_WAIT_0 = 0x00000000,
		STATUS_ABANDONED_WAIT_0 = 0x00000080,
		WAIT_OBJECT_0 = STATUS_WAIT_0,
		WAIT_ABANDONED_0 = STATUS_ABANDONED_WAIT_0,
	}
	
	
	enum: UINT
	{
		SPI_GETNONCLIENTMETRICS = 41,
		SPI_GETWORKAREA = 48,
		SPI_GETANIMATION = 72,
		SPI_GETWHEELSCROLLLINES = 104,
		SPI_GETWHEELSCROLLCHARS = 108,
		// ...
	}
	
	
	enum: DWORD
	{
		ABM_GETTASKBARPOS = 0x00000005,
		// ...
	}
	
	
	enum: UINT
	{
		ABE_LEFT = 0,
		ABE_TOP = 1,
		ABE_RIGHT = 2,
		ABE_BOTTOM = 3,
	}
	
	
	const LPSTR IDC_APPSTARTING =  cast(LPSTR)32650;
	const LPSTR IDC_HAND = cast(LPSTR)32649; // Windows 98+
	const LPSTR IDC_HELP = cast(LPSTR)32651;
	const LPSTR IDC_IBEAM = cast(LPSTR)32513;
	const LPSTR IDC_NO = cast(LPSTR)32648;
	const LPSTR IDC_SIZEALL = cast(LPSTR)32646;
	const LPSTR IDC_SIZENESW = cast(LPSTR)32643;
	const LPSTR IDC_SIZENS = cast(LPSTR)32645;
	const LPSTR IDC_SIZENWSE = cast(LPSTR)32642;
	const LPSTR IDC_SIZEWE = cast(LPSTR)32644;
	const LPSTR IDC_WAIT = cast(LPSTR)32514;
	
	
	enum: WORD
	{
		MK_LBUTTON = 0x0001,
		MK_RBUTTON = 0x0002,
		MK_SHIFT = 0x0004,
		MK_CONTROL = 0x0008,
		MK_MBUTTON = 0x0010,
	}
	
	
	enum: UINT
	{
		GMEM_MOVEABLE = 0x0002,
		GMEM_DDESHARE = 0x2000,
		GMEM_SHARE = 0x2000,
	}
	
	
	enum
	{
		LOGPIXELSX = 88,
		LOGPIXELSY = 90,
	}
	
	
	enum
	{
		MB_SERVICE_NOTIFICATION = 0x00200000,
	}
	
	
	enum
	{
		DLGC_WANTARROWS = 0x0001,
		DLGC_WANTTAB = 0x0002,
		DLGC_WANTALLKEYS = 0x0004,
		DLGC_HASSETSEL = 0x0008,
		DLGC_RADIOBUTTON = 0x0040,
		DLGC_WANTCHARS = 0x0080,
		DLGC_STATIC = 0x0100,
	}
	
	
	enum
	{
		LB_OKAY = 0,
		LB_ERR = -1,
		LB_ERRSPACE = -2,
	}
	
	
	enum: UINT
	{
		LB_GETCOUNT = 0x018B,
		LB_GETITEMDATA = 0x0199,
		LB_ADDSTRING = 0x0180,
		LB_SETITEMDATA = 0x019A,
		LB_RESETCONTENT = 0x0184,
		LB_INSERTSTRING = 0x0181,
		LB_DELETESTRING = 0x0182,
		LB_GETHORIZONTALEXTENT = 0x0193,
		LB_SETHORIZONTALEXTENT = 0x0194,
		LB_SETITEMHEIGHT = 0x01A0,
		LB_GETITEMHEIGHT = 0x01A1,
		LB_GETSELCOUNT = 0x0190,
		LB_GETSELITEMS = 0x0191,
		LB_SETCURSEL = 0x0186,
		LB_GETCURSEL = 0x0188,
		LB_SETTOPINDEX = 0x0197,
		LB_GETTOPINDEX = 0x018E,
		LB_SELITEMRANGE = 0x0183,
		LB_SETSEL = 0x0185,
		LB_FINDSTRING = 0x018F,
		LB_FINDSTRINGEXACT = 0x01A2,
		LB_GETITEMRECT = 0x0198,
		LB_GETSEL = 0x0187,
		LB_ITEMFROMPOINT = 0x01A9,
		LB_ADDFILE = 0x0196,
		LB_DIR = 0x018D,
	}
	
	
	enum: DWORD
	{
		LBS_NOINTEGRALHEIGHT = 0x0100,
		LBS_MULTICOLUMN = 0x0200,
		LBS_DISABLENOSCROLL = 0x1000,
		LBS_NOSEL = 0x4000,
		LBS_EXTENDEDSEL = 0x0800,
		LBS_MULTIPLESEL = 0x0008,
		LBS_SORT = 0x0002,
		LBS_USETABSTOPS = 0x0080,
		LBS_OWNERDRAWVARIABLE = 0x0020,
		LBS_OWNERDRAWFIXED = 0x0010,
		LBS_NOTIFY = 0x0001,
		LBS_HASSTRINGS = 0x0040,
	}
	
	
	enum
	{
		LBN_ERRSPACE = -2,
		LBN_SELCHANGE = 1,
		LBN_DBLCLK = 2,
		LBN_SELCANCEL = 3,
		LBN_SETFOCUS = 4,
		LBN_KILLFOCUS = 5,
	}
	
	
	enum
	{
		CB_OKAY = 0,
		CB_ERR = -1,
		CB_ERRSPACE = -2,
	}
	
	
	enum: UINT
	{
		CB_SETCURSEL = 0x014E,
		CB_GETCURSEL = 0x0147,
		CB_FINDSTRING = 0x014C,
		CB_FINDSTRINGEXACT = 0x0158,
		CB_SETITEMHEIGHT = 0x0153,
		CB_GETITEMHEIGHT = 0x0154,
		CB_ADDSTRING = 0x0143,
		CB_DELETESTRING = 0x0144,
		CB_DIR = 0x0145,
		CB_INSERTSTRING = 0x014A,
		CB_RESETCONTENT = 0x014B,
		CB_SETITEMDATA = 0x0151,
		CB_GETDROPPEDWIDTH = 0x015f,
		CB_SETDROPPEDWIDTH = 0x0160,
		CB_LIMITTEXT = 0x0141,
		CB_GETEDITSEL = 0x0140,
		CB_SETEDITSEL = 0x0142,
		CB_SHOWDROPDOWN = 0x014F,
		CB_GETDROPPEDSTATE = 0x0157,
	}
	
	
	enum: DWORD
	{
		CBS_SORT = 0x0100,
		CBS_HASSTRINGS = 0x0200,
		CBS_NOINTEGRALHEIGHT = 0x0400,
	}
	
	
	enum
	{
		CBN_SELCHANGE = 1,
		CBN_SETFOCUS = 3,
		CBN_KILLFOCUS = 4,
		CBN_EDITCHANGE = 5,
	}
	
	
	enum: UINT
	{
		TVE_COLLAPSE = 0x0001,
		TVE_EXPAND = 0x0002,
		TVE_TOGGLE = 0x0003,
	}
	
	
	enum: UINT
	{
		TVIS_SELECTED = 0x0002,
		TVIS_EXPANDED = 0x0020,
	}
	
	
	enum: UINT
	{
		TVIF_TEXT = 0x0001,
		TVIF_IMAGE = 0x0002,
		TVIF_PARAM = 0x0004,
		TVIF_STATE = 0x0008,
		TVIF_HANDLE = 0x0010,
		TVIF_SELECTEDIMAGE = 0x0020,
		TVIF_CHILDREN = 0x0040,
		TVIF_INTEGRAL = 0x0080, // IE4+
	}
	
	
	const int I_CHILDRENCALLBACK = -1;
	
	
	enum: UINT
	{
		TVGN_FIRSTVISIBLE = 0x0005,
		TVGN_CARET = 0x0009,
	}
	
	
	enum: UINT
	{
		TV_FIRST = 0x1100,
		
		TVM_INSERTITEMA = TV_FIRST + 0,
		TVM_DELETEITEM = TV_FIRST + 1,
		TVM_EXPAND = TV_FIRST + 2,
		TVM_GETITEMRECT = TV_FIRST + 4,
		TVM_GETINDENT = TV_FIRST + 6,
		TVM_SETINDENT = TV_FIRST + 7,
		TVM_SETIMAGELIST = TV_FIRST + 9,
		TVM_GETNEXTITEM = TV_FIRST + 10,
		TVM_SELECTITEM = TV_FIRST + 11,
		TVM_GETITEMA = TV_FIRST + 12,
		TVM_SETITEMA = TV_FIRST + 13,
		TVM_EDITLABELA = TV_FIRST + 14,
		TVM_GETVISIBLECOUNT = TV_FIRST + 16,
		TVM_HITTEST = TV_FIRST + 17,
		TVM_ENSUREVISIBLE = TV_FIRST + 20,
		TVM_SETITEMHEIGHT = TV_FIRST + 27, // IE4+
		TVM_GETITEMHEIGHT = TV_FIRST + 28, // IE4+
		TVM_INSERTITEMW = TV_FIRST + 50,
		TVM_SETITEMW = TV_FIRST + 63,
		
		TVN_FIRST = cast(UINT)-400,
		
		TVN_SELCHANGINGA = TVN_FIRST - 1,
		TVN_SELCHANGEDA = TVN_FIRST - 2,
		TVN_GETDISPINFOA = TVN_FIRST - 3,
		TVN_ITEMEXPANDINGA = TVN_FIRST - 5,
		TVN_ITEMEXPANDEDA = TVN_FIRST - 6,
		TVN_BEGINLABELEDITA = TVN_FIRST - 10,
		TVN_ENDLABELEDITA = TVN_FIRST - 11,
		
		TVN_SELCHANGINGW = TVN_FIRST - 50,
		TVN_SELCHANGEDW = TVN_FIRST - 51,
		TVN_GETDISPINFOW = TVN_FIRST - 52,
		TVN_ITEMEXPANDINGW = TVN_FIRST - 54,
		TVN_ITEMEXPANDEDW = TVN_FIRST - 55,
		TVN_BEGINLABELEDITW = TVN_FIRST - 59,
		TVN_ENDLABELEDITW = TVN_FIRST - 60,
	}
	
	
	enum: DWORD
	{
		TVS_HASBUTTONS = 0x0001,
		TVS_HASLINES = 0x0002,
		TVS_LINESATROOT = 0x0004,
		TVS_EDITLABELS = 0x0008,
		TVS_SHOWSELALWAYS = 0x0020,
		TVS_CHECKBOXES = 0x0100, // IE3+
		TVS_TRACKSELECT = 0x0200, // IE3+
		TVS_FULLROWSELECT = 0x1000, // IE4+
		TVS_NOSCROLL = 0x2000, // IE4+
		TVS_SINGLEEXPAND = 0x0400, // IE4+
	}
	
	
	version(DFL_D2_AND_ABOVE)
	{
		/+ // DMD 2.012: Error: cannot implicitly convert expression (cast(HANDLE)cast(void*)-65536u) of type const(HANDLE) to int
		const HTREEITEM TVI_ROOT = cast(HTREEITEM)-0x10000;
		const HTREEITEM TVI_FIRST = cast(HTREEITEM)-0x0FFFF;
		const HTREEITEM TVI_LAST = cast(HTREEITEM)-0x0FFFE;
		const HTREEITEM TVI_SORT = cast(HTREEITEM)-0x0FFFD;
		+/
		enum: HTREEITEM
		{
			TVI_ROOT = cast(HTREEITEM)-0x10000,
			TVI_FIRST = cast(HTREEITEM)-0x0FFFF,
			TVI_LAST = cast(HTREEITEM)-0x0FFFE,
			TVI_SORT = cast(HTREEITEM)-0x0FFFD,
		}
	}
	else
	{
		const HTREEITEM TVI_ROOT = cast(HTREEITEM)-0x10000;
		const HTREEITEM TVI_FIRST = cast(HTREEITEM)-0x0FFFF;
		const HTREEITEM TVI_LAST = cast(HTREEITEM)-0x0FFFE;
		const HTREEITEM TVI_SORT = cast(HTREEITEM)-0x0FFFD;
	}
	
	
	enum: UINT
	{
		TVC_UNKNOWN = 0x0000,
		TVC_BYMOUSE = 0x0001,
		TVC_BYKEYBOARD = 0x0002,
	}
	
	
	enum: WPARAM
	{
		TVSIL_NORMAL = 0,
		TVSIL_STATE = 2,
	}
	
	
	enum: UINT
	{
		SB_SETTEXTA = WM_USER + 1,
		SB_SETPARTS = WM_USER + 4,
		SB_SIMPLE = WM_USER + 9,
		SB_SETTEXTW = WM_USER + 11,
	}
	
	
	enum: DWORD
	{
		SBARS_SIZEGRIP = 0x0100,
	}
	
	
	enum: WPARAM
	{
		SBT_NOBORDERS = 0x0100,
		SBT_POPOUT = 0x0200,
		SBT_RTLREADING = 0x0400,
		SBT_OWNERDRAW = 0x1000,
	}
	
	
	enum: LRESULT
	{
		CDRF_DODEFAULT = 0x0,
		CDRF_NEWFONT = 0x2,
		CDRF_NOTIFYITEMDRAW = 0x20,
		CDRF_NOTIFYITEMERASE = 0x80,
	}
	
	
	enum: DWORD
	{
		CDDS_ITEM = 0x00010000,
	}
	
	
	enum: UINT
	{
		CDIS_SELECTED = 0x0001,
	}
	
	
	const LPWSTR LPSTR_TEXTCALLBACKW = cast(LPWSTR)-1L;
	const LPSTR LPSTR_TEXTCALLBACKA = cast(LPSTR)-1L;
	
	
	enum: UINT
	{
		CCM_FIRST = 0x2000,
		CCM_SETVERSION = CCM_FIRST + 0x7,
	}
	
	
	enum: UINT
	{
		LVM_FIRST = 0x1000,
		
		LVM_SETBKCOLOR = LVM_FIRST + 1,
		LVM_SETIMAGELIST = LVM_FIRST + 3,
		LVM_SETITEMA = LVM_FIRST + 6,
		LVM_INSERTITEMA = LVM_FIRST + 7,
		LVM_DELETEITEM = LVM_FIRST + 8,
		LVM_DELETEALLITEMS = LVM_FIRST + 9,
		LVM_SETCALLBACKMASK = LVM_FIRST + 11,
		LVM_GETNEXTITEM = LVM_FIRST + 12,
		LVM_GETITEMRECT = LVM_FIRST + 14,
		LVM_ENSUREVISIBLE = LVM_FIRST + 19,
		LVM_REDRAWITEMS = LVM_FIRST + 21,
		LVM_ARRANGE = LVM_FIRST + 22,
		LVM_EDITLABELA = LVM_FIRST + 23,
		LVM_GETCOLUMNA = LVM_FIRST + 25,
		LVM_SETCOLUMNA = LVM_FIRST + 26,
		LVM_INSERTCOLUMNA = LVM_FIRST + 27,
		LVM_DELETECOLUMN = LVM_FIRST + 28,
		LVM_SETCOLUMNWIDTH = LVM_FIRST + 30,
		LVM_SETTEXTCOLOR = LVM_FIRST + 36,
		LVM_SETTEXTBKCOLOR = LVM_FIRST + 38,
		LVM_SETITEMSTATE = LVM_FIRST + 43,
		LVM_GETITEMSTATE = LVM_FIRST + 44,
		LVM_SETITEMTEXTA = LVM_FIRST + 46,
		LVM_SORTITEMS = LVM_FIRST + 48,
		LVM_SETEXTENDEDLISTVIEWSTYLE = LVM_FIRST + 54,
		LVM_GETEXTENDEDLISTVIEWSTYLE = LVM_FIRST + 55,
		LVM_INSERTITEMW = LVM_FIRST + 77,
		LVM_SETCOLUMNW = LVM_FIRST + 96,
		LVM_INSERTCOLUMNW = LVM_FIRST + 97,
		LVM_SETITEMTEXTW = LVM_FIRST + 116,
		LVM_EDITLABELW = LVM_FIRST + 118,
	}
	
	
	enum: UINT
	{
		LVIS_OVERLAYMASK = 0x0F00,
		LVIS_STATEIMAGEMASK = 0xF000,
	}
	
	
	enum: int
	{
		LVSCW_AUTOSIZE = -1,
		LVSCW_AUTOSIZE_USEHEADER = -2,
	}
	
	
	enum: UINT
	{
		LVNI_ALL = 0x0000,
		LVNI_FOCUSED = 0x0001,
		LVNI_SELECTED = 0x0002,
		LVNI_CUT = 0x0004,
		LVNI_DROPHILITED = 0x0008,
		
		LVNI_ABOVE = 0x0100,
		LVNI_BELOW = 0x0200,
		LVNI_TOLEFT = 0x0400,
		LVNI_TORIGHT = 0x0800,
	}
	
	
	enum: UINT
	{
		LVN_FIRST = cast(UINT)-100,
		
		LVN_ITEMCHANGING = (LVN_FIRST - 0),
		LVN_ITEMCHANGED = (LVN_FIRST - 1),
		
		LVN_BEGINLABELEDITA = LVN_FIRST - 5,
		LVN_BEGINLABELEDITW = LVN_FIRST - 75,
		
		LVN_ENDLABELEDITA = LVN_FIRST - 6,
		LVN_ENDLABELEDITW = LVN_FIRST - 76,
		
		LVN_COLUMNCLICK = LVN_FIRST - 8,
		
		LVN_GETDISPINFOA = LVN_FIRST - 50,
		LVN_GETDISPINFOW = LVN_FIRST - 77,
	}
	
	
	enum: UINT
	{
		LVCF_FMT = 0x0001,
		LVCF_WIDTH = 0x0002,
		LVCF_TEXT = 0x0004,
		LVCF_SUBITEM = 0x0008,
	}
	
	
	enum: int
	{
		LVCFMT_LEFT = 0x0000,
		LVCFMT_RIGHT = 0x0001,
		LVCFMT_CENTER = 0x0002,
		LVCFMT_JUSTIFYMASK = 0x0003,
	}
	
	
	enum: UINT
	{
		LVIF_TEXT = 0x0001,
		LVIF_IMAGE = 0x0002,
		LVIF_PARAM = 0x0004,
		LVIF_STATE = 0x0008,
	}
	
	
	enum: UINT
	{
		LVIS_FOCUSED = 0x0001,
		LVIS_SELECTED = 0x0002,
		LVIS_CUT = 0x0004,
		LVIS_DROPHILITED = 0x0008,
	}
	
	
	enum: int
	{
		LVA_DEFAULT = 0x0000,
		LVA_ALIGNLEFT = 0x0001,
		LVA_ALIGNTOP = 0x0002,
		LVA_SNAPTOGRID = 0x0005,
	}
	
	
	enum: int
	{
		LVIR_BOUNDS = 0,
		LVIR_ICON = 1,
		LVIR_LABEL = 2,
		LVIR_SELECTBOUNDS = 3,
	}
	
	
	enum: UINT
	{
		LVS_ALIGNTOP = 0x0000,
		LVS_ALIGNLEFT = 0x0800,
		
		LVS_ICON = 0x0000,
		LVS_REPORT = 0x0001,
		LVS_SMALLICON = 0x0002,
		LVS_LIST = 0x0003,
		LVS_SINGLESEL = 0x0004,
		LVS_SHOWSELALWAYS = 0x0008,
		LVS_SORTASCENDING = 0x0010,
		LVS_SORTDESCENDING = 0x0020,
		LVS_SHAREIMAGELISTS = 0x0040,
		LVS_NOLABELWRAP = 0x0080,
		LVS_AUTOARRANGE = 0x0100,
		LVS_EDITLABELS = 0x0200,
		LVS_OWNERDATA = 0x1000,
		LVS_NOSCROLL = 0x2000,
	}
	
	
	enum: DWORD
	{
		LVS_EX_GRIDLINES = 0x00000001,
		LVS_EX_SUBITEMIMAGES = 0x00000002,
		LVS_EX_CHECKBOXES = 0x00000004,
		LVS_EX_TRACKSELECT = 0x00000008,
		LVS_EX_HEADERDRAGDROP = 0x00000010,
		LVS_EX_FULLROWSELECT = 0x00000020,
		LVS_EX_ONECLICKACTIVATE = 0x00000040,
		LVS_EX_TWOCLICKACTIVATE = 0x00000080,
		
		// IE4+
		LVS_EX_FLATSB = 0x00000100,
		LVS_EX_REGIONAL = 0x00000200,
		LVS_EX_INFOTIP = 0x00000400,
		LVS_EX_UNDERLINEHOT = 0x00000800,
		LVS_EX_UNDERLINECOLD = 0x00001000,
		LVS_EX_MULTIWORKAREAS = 0x00002000,
	}
	
	
	enum
	{
		LVSIL_NORMAL = 0,
		LVSIL_SMALL = 1,
		LVSIL_STATE = 2,
	}
	
	
	enum
	{
		I_IMAGECALLBACK = -1,
	}
	
	
	enum: UINT
	{
		TCM_FIRST = 0x1300,
		
		TCM_SETITEMA = TCM_FIRST + 6,
		TCM_INSERTITEMA = TCM_FIRST + 7,
		TCM_DELETEITEM = TCM_FIRST + 8,
		TCM_DELETEALLITEMS = TCM_FIRST + 9,
		TCM_GETITEMRECT = TCM_FIRST + 10,
		TCM_GETCURSEL = TCM_FIRST + 11,
		TCM_SETCURSEL = TCM_FIRST + 12,
		TCM_SETITEMEXTRA = TCM_FIRST + 14,
		TCM_ADJUSTRECT = TCM_FIRST + 40,
		TCM_SETITEMSIZE = TCM_FIRST + 41,
		TCM_SETPADDING = TCM_FIRST + 43,
		TCM_GETROWCOUNT = TCM_FIRST + 44,
		TCM_SETTOOLTIPS = TCM_FIRST + 46,
		TCM_SETITEMW = TCM_FIRST + 61,
		TCM_INSERTITEMW = TCM_FIRST + 62,
	}
	
	
	enum: UINT
	{
		TCIF_TEXT = 0x0001,
		TCIF_IMAGE = 0x0002,
		TCIF_RTLREADING = 0x0004,
		TCIF_PARAM = 0x0008,
	}
	
	
	enum: DWORD
	{
		TCS_FORCEICONLEFT = 0x0010,
		TCS_FORCELABELLEFT = 0x0020,
		TCS_TABS = 0x0000,
		TCS_BUTTONS = 0x0100,
		TCS_SINGLELINE = 0x0000,
		TCS_MULTILINE = 0x0200,
		TCS_RIGHTJUSTIFY = 0x0000,
		TCS_FIXEDWIDTH = 0x0400,
		TCS_RAGGEDRIGHT = 0x0800,
		TCS_FOCUSONBUTTONDOWN = 0x1000,
		TCS_OWNERDRAWFIXED = 0x2000,
		TCS_TOOLTIPS = 0x4000,
		TCS_FOCUSNEVER = 0x8000,
		
		// IE3+
		TCS_SCROLLOPPOSITE = 0x0001,
		TCS_BOTTOM = 0x0002,
		TCS_RIGHT = 0x0002,
		TCS_MULTISELECT = 0x0004,
		TCS_HOTTRACK = 0x0040,
		TCS_VERTICAL = 0x0080,
		
		// IE4+
		TCS_FLATBUTTONS = 0x0008,
	}
	
	
	enum: UINT
	{
		TCN_FIRST = cast(UINT)-550,
		
		TCN_SELCHANGE = TCN_FIRST - 1,
		TCN_SELCHANGING = TCN_FIRST - 2,
	}
	
	
	enum
	{
		HTERROR = -2,
		HTTRANSPARENT = -1,
		HTNOWHERE = 0,
		HTCLIENT = 1,
		HTCAPTION = 2,
		HTSYSMENU = 3,
		HTGROWBOX = 4,
		HTMENU = 5,
		HTHSCROLL = 6,
		HTVSCROLL = 7,
		HTMINBUTTON = 8,
		HTMAXBUTTON = 9,
		HTLEFT = 10,
		HTRIGHT = 11,
		HTTOP = 12,
		HTTOPLEFT = 13,
		HTTOPRIGHT = 14,
		HTBOTTOM = 15,
		HTBOTTOMLEFT = 16,
		HTBOTTOMRIGHT = 17,
		HTBORDER = 18,
		HTOBJECT = 19,
		HTCLOSE = 20,
		HTHELP = 21,
		HTSIZE = HTGROWBOX,
		HTREDUCE = HTMINBUTTON,
		HTZOOM = HTMAXBUTTON,
		HTSIZEFIRST = HTLEFT,
		HTSIZELAST = HTBOTTOMRIGHT,
	}
	
	
	enum
	{
		WVR_VALIDRECTS = 0x0400,
	}
	
	
	enum: UINT
	{
		NIF_MESSAGE = 0x00000001,
		NIF_ICON = 0x00000002,
		NIF_TIP = 0x00000004,
	}
	
	
	enum: DWORD
	{
		NIM_ADD = 0x00000000,
		NIM_MODIFY = 0x00000001,
		NIM_DELETE = 0x00000002,
	}
	
	
	enum: DWORD
	{
		VER_PLATFORM_WIN32s = 0,
		VER_PLATFORM_WIN32_WINDOWS = 1,
		VER_PLATFORM_WIN32_NT = 2,
	}
	
	
	enum: UINT
	{
		SIF_RANGE = 0x0001,
		SIF_PAGE = 0x0002,
		SIF_POS = 0x0004,
		SIF_DISABLENOSCROLL = 0x0008,
		SIF_ALL = 23,
	}
	
	
	enum: int
	{
		SM_SWAPBUTTON = 23,
		
		SM_CXFRAME = 32,
		SM_CYFRAME = 33,
		
		SM_CXSMICON = 49,
		SM_CYSMICON = 50,
		
		SM_CYSMCAPTION = 51,
		
		SM_CXSIZEFRAME = SM_CXFRAME,
		SM_CYSIZEFRAME = SM_CYFRAME,
		
		SM_CYMENU = 15,
		
		SM_CXVSCROLL = 2,
		SM_CYHSCROLL = 3,
	}
	
	
	enum: UINT
	{
		DFC_SCROLL = 3,
	}
	
	
	enum: UINT
	{
		DFCS_SCROLLSIZEGRIP = 0x0008,
	}
	
	
	enum: UINT
	{
		LR_LOADFROMFILE = 0x0010,
		LR_DEFAULTSIZE = 0x0040,
		LR_COPYFROMRESOURCE = 0x4000,
		LR_SHARED = 0x8000,
	}
	
	
	enum: COLORREF
	{
		CLR_INVALID = 0xFFFFFFFF,
		CLR_NONE = CLR_INVALID,
	}
	
	
	enum: UINT
	{
		DT_TOP = 0x00000000,
		DT_LEFT = 0x00000000,
		DT_CENTER = 0x00000001,
		DT_RIGHT = 0x00000002,
		DT_VCENTER = 0x00000004,
		DT_BOTTOM = 0x00000008,
		DT_WORDBREAK = 0x00000010,
		DT_SINGLELINE = 0x00000020,
		DT_EXPANDTABS = 0x00000040,
		DT_TABSTOP = 0x00000080,
		DT_NOCLIP = 0x00000100,
		DT_EXTERNALLEADING = 0x00000200,
		DT_CALCRECT = 0x00000400,
		DT_NOPREFIX = 0x00000800,
		DT_INTERNAL = 0x00001000,
		DT_EDITCONTROL = 0x00002000,
		DT_PATH_ELLIPSIS = 0x00004000,
		DT_END_ELLIPSIS = 0x00008000,
		DT_MODIFYSTRING = 0x00010000,
		DT_RTLREADING = 0x00020000,
		DT_WORD_ELLIPSIS = 0x00040000,
	}
	
	
	enum: UINT
	{
		CF_TEXT = 1,
		CF_BITMAP = 2,
		CF_METAFILEPICT = 3,
		CF_SYLK = 4,
		CF_DIF = 5,
		CF_TIFF = 6,
		CF_OEMTEXT = 7,
		CF_DIB = 8,
		CF_PALETTE = 9,
		CF_PENDATA = 10,
		CF_RIFF = 11,
		CF_WAVE = 12,
		CF_UNICODETEXT = 13,
		CF_ENHMETAFILE = 14,
		CF_HDROP = 15,
		CF_LOCALE = 16,
	}
	
	
	enum: UINT
	{
		BIF_RETURNONLYFSDIRS = 0x0001,
		BIF_NEWDIALOGSTYLE = 0x0040,
		BIF_NONEWFOLDERBUTTON = 0x0200, // shell32.dll 6.0+
	}
	
	
	enum
	{
		TRANSPARENT = 1,
		OPAQUE = 2,
	}
	
	
	enum: UINT
	{
		ETO_OPAQUE = 0x0002,
		ETO_CLIPPED = 0x0004,
	}
	
	
	enum: UINT
	{
		PS_SOLID = 0,
		PS_DASH = 1,
		PS_DOT = 2,
		PS_DASHDOT = 3,
		PS_DASHDOTDOT = 4,
		PS_NULL = 5,
		PS_INSIDEFRAME = 6,
	}
	
	
	enum: UINT
	{
		IMAGE_BITMAP = 0,
		IMAGE_ICON = 1,
		IMAGE_CURSOR = 2,
	}
	
	
	const LPCSTR IDI_HAND = cast(LPCSTR)32513;
	const LPCSTR IDI_QUESTION = cast(LPCSTR)32514;
	const LPCSTR IDI_EXCLAMATION = cast(LPCSTR)32515;
	const LPCSTR IDI_ASTERISK = cast(LPCSTR)32516;
	const LPCSTR IDI_INFORMATION = IDI_ASTERISK;
	
	
	const LPCSTR RT_STRING = cast(LPCSTR)6;
	
	
	enum: LONG
	{
		HS_HORIZONTAL = 0,
		HS_VERTICAL = 1,
		HS_FDIAGONAL = 2,
		HS_BDIAGONAL = 3,
		HS_CROSS = 4,
		HS_DIAGCROSS = 5,
	}
	
	
	enum: DWORD
	{
		LOAD_LIBRARY_AS_DATAFILE = 0x00000002,
	}
	
	
	enum: DWORD
	{
		// IE3+
		ICC_LISTVIEW_CLASSES = 0x00000001,
		ICC_TREEVIEW_CLASSES = 0x00000002,
		ICC_BAR_CLASSES = 0x00000004, // tool/status/track
		ICC_TAB_CLASSES = 0x00000008,
		ICC_UPDOWN_CLASS = 0x00000010,
		ICC_PROGRESS_CLASS = 0x00000020,
		ICC_HOTKEY_CLASS = 0x00000040,
		ICC_ANIMATE_CLASS = 0x00000080,
		ICC_WIN95_CLASSES = 0x000000FF,
		ICC_DATE_CLASSES = 0x00000100,
		ICC_USEREX_CLASSES = 0x00000200,
		ICC_COOL_CLASSES = 0x00000400,
		
		ICC_STANDARD_CLASSES = 0x00004000,
		
		// IE4+
		ICC_INTERNET_CLASSES = 0x00000800,
		ICC_PAGESCROLLER_CLASS = 0x00001000,
		ICC_NATIVEFNTCTL_CLASS = 0x00002000,
	}
	
	
	enum: UINT
	{
		PBM_SETRANGE = WM_USER + 1,
		PBM_SETPOS = WM_USER + 2,
		PBM_DELTAPOS = WM_USER + 3,
		PBM_SETSTEP = WM_USER + 4,
		PBM_STEPIT = WM_USER + 5,
	}
	
	
	const DWORD MAX_COMPUTERNAME_LENGTH = 15;
	
	const DWORD LF_FACESIZE = 32;
	
	
	typedef HANDLE HIMAGELIST;
	
	
	enum: UINT
	{
		ILD_NORMAL = 0,
	}
	
	
	enum: UINT
	{
		//ILC_COLOR = ,
		ILC_COLOR4 = 0x0004,
		ILC_COLOR8 = 0x0008,
		ILC_COLOR16 = 0x0010,
		ILC_COLOR24 = 0x0018,
		ILC_COLOR32 = 0x0020,
		
		ILC_MASK = 0x0001,
	}
	
	
	// Rich edit.
	alias DWORD function(/+ DWORD_PTR +/ DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG* pcb) EDITSTREAMCALLBACK;
	
	
	alias DWORD LCID;
	
	
	struct WINDOWPOS
	{
		HWND hwnd;
		HWND hwndInsertAfter;
		int  x;
		int  y;
		int  cx;
		int  cy;
		UINT flags;                
	}
	alias WINDOWPOS* LPWINDOWPOS;
	alias WINDOWPOS* PWINDOWPOS;
	
	
	struct WNDCLASSW
	{
		UINT style;
		WNDPROC lpfnWndProc;
		int cbClsExtra;
		int cbWndExtra;
		HANDLE hInstance;
		HICON hIcon;
		HCURSOR hCursor;
		HBRUSH hbrBackground;
		LPCWSTR lpszMenuName;
		LPCWSTR lpszClassName;
	}
	alias WNDCLASSW* LPWNDCLASSW;
	
	
	struct OSVERSIONINFOA
	{
		DWORD dwOSVersionInfoSize;
		DWORD dwMajorVersion;
		DWORD dwMinorVersion;
		DWORD dwBuildNumber;
		DWORD dwPlatformId;
		CHAR[128] szCSDVersion;
	}
	alias OSVERSIONINFOA* LPOSVERSIONINFOA;
	
	
	const HWND HWND_MESSAGE = cast(HWND)-3; // Win2000/XP only.
	
	
	struct NOTIFYICONDATA
	{
		 DWORD cbSize; 
		 HWND hWnd; 
		 UINT uID; 
		 UINT uFlags; 
		 UINT uCallbackMessage; 
		 HICON hIcon; 
		 char[64] szTip; 
	}
	alias NOTIFYICONDATA* PNOTIFYICONDATA;
	
	
	// Unaligned!
	struct SHITEMID
	{
		align(1):
		USHORT cb; // Size including cb.
		BYTE[1] abID;
	}
	alias SHITEMID* PSHITEMID;
	alias SHITEMID* LPSHITEMID;
	alias SHITEMID* LPCSHITEMID;
	
	
	struct ITEMIDLIST
	{
		SHITEMID mkid;
	}
	alias ITEMIDLIST* PITEMIDLIST;
	alias ITEMIDLIST* LPITEMIDLIST;
	alias ITEMIDLIST* LPCITEMIDLIST;
	
	
	alias int function(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData) BFFCALLBACK;
	
	
	struct BROWSEINFOA
	{
		HWND hwndOwner;
		LPCITEMIDLIST pidlRoot;
		LPSTR pszDisplayName;
		LPCSTR lpszTitle;
		UINT ulFlags;
		BFFCALLBACK lpfn;
		LPARAM lParam;
		int iImage;
	}
	alias BROWSEINFOA* PBROWSEINFOA;
	alias BROWSEINFOA* LPBROWSEINFOA;
	
	
	struct BROWSEINFOW
	{
		HWND hwndOwner;
		LPCITEMIDLIST pidlRoot;
		LPWSTR pszDisplayName;
		LPCWSTR lpszTitle;
		UINT ulFlags;
		BFFCALLBACK lpfn;
		LPARAM lParam;
		int iImage;
	}
	alias BROWSEINFOW* PBROWSEINFOW;
	alias BROWSEINFOW* LPBROWSEINFOW;
	
	
	struct LOGBRUSH
	{
		UINT lbStyle;
		COLORREF lbColor;
		LONG lbHatch;
	}
	alias LOGBRUSH* LPLOGBRUSH;
	
	
	struct DRAWTEXTPARAMS
	{ 
		UINT cbSize; 
		int iTabLength; 
		int iLeftMargin; 
		int iRightMargin; 
		UINT uiLengthDrawn; 
	}
	alias DRAWTEXTPARAMS* LPDRAWTEXTPARAMS;
	
	
	struct NMHDR
	{ 
		HWND hwndFrom;
		UINT idFrom;
		UINT code;
	}
	alias NMHDR* LPNMHDR;
	
	
	struct NMCUSTOMDRAW
	{
		NMHDR hdr;
		DWORD dwDrawStage;
		HDC hdc;
		RECT rc;
		/+ DWORD_PTR +/ DWORD dwItemSpec;
		UINT uItemState;
		LPARAM lItemlParam;
	}
	alias NMCUSTOMDRAW* LPNMCUSTOMDRAW;
	
	
	struct NMTVCUSTOMDRAW
	{
		NMCUSTOMDRAW nmcd;
		COLORREF clrText;
		COLORREF clrTextBk;
		int iLevel; // IE4+
	}
	alias NMTVCUSTOMDRAW* LPNMTVCUSTOMDRAW;
	
	
	struct NM_LISTVIEW
	{
		NMHDR hdr;
		int iItem;
		int iSubItem;
		UINT uNewState;
		UINT uOldState;
		UINT uChanged;
		POINT ptAction;
		LPARAM lParam;
	}
	
	
	struct LVITEMA
	{
		UINT mask;
		int iItem;
		int iSubItem;
		UINT state;
		UINT stateMask;
		LPSTR pszText;
		int cchTextMax;
		int iImage;
		LPARAM lParam;
	}
	alias LVITEMA* LPLVITEMA;
	alias LVITEMA* PLVITEMA;
	alias LVITEMA LV_ITEMA;
	alias LVITEMA* LPLV_ITEMA;
	alias LVITEMA* PLV_ITEMA;
	
	
	struct LVITEMW
	{
		UINT mask;
		int iItem;
		int iSubItem;
		UINT state;
		UINT stateMask;
		LPWSTR pszText;
		int cchTextMax;
		int iImage;
		LPARAM lParam;
	}
	alias LVITEMW* LPLVITEMW;
	alias LVITEMW* PLVITEMW;
	alias LVITEMW LV_ITEMW;
	alias LVITEMW* LPLV_ITEMW;
	alias LVITEMW* PLV_ITEMW;
	
	
	struct LVDISPINFOA
	{
		NMHDR hdr;
		LVITEMA item;
	}
	alias LVDISPINFOA* LPLVDISPINFOA;
	alias LVDISPINFOA* PLVDISPINFOA;
	alias LVDISPINFOA LV_DISPINFOA;
	alias LVDISPINFOA* LPLV_DISPINFOA;
	alias LVDISPINFOA* PLV_DISPINFOA;
	
	
	struct LVDISPINFOW
	{
		NMHDR hdr;
		LVITEMW item;
	}
	alias LVDISPINFOW* LPLVDISPINFOW;
	alias LVDISPINFOW* PLVDISPINFOW;
	alias LVDISPINFOW LV_DISPINFOW;
	alias LVDISPINFOW* LPLV_DISPINFOW;
	alias LVDISPINFOW* PLV_DISPINFOW;
	
	
	struct LVCOLUMNA
	{
		UINT mask;
		int fmt;
		int cx;
		LPSTR pszText;
		int cchTextMax;
		int iSubItem;
	}
	alias LVCOLUMNA* LPLVCOLUMNA;
	alias LVCOLUMNA* PLVCOLUMNA;
	alias LVCOLUMNA LV_COLUMNA;
	alias LVCOLUMNA* LPLV_COLUMNA;
	alias LVCOLUMNA* PLV_COLUMNA;
	
	
	struct LVCOLUMNW
	{
		UINT mask;
		int fmt;
		int cx;
		LPWSTR pszText;
		int cchTextMax;
		int iSubItem;
	}
	alias LVCOLUMNW* LPLVCOLUMNW;
	alias LVCOLUMNW* PLVCOLUMNW;
	alias LVCOLUMNW LV_COLUMNW;
	alias LVCOLUMNW* LPLV_COLUMNW;
	alias LVCOLUMNW* PLV_COLUMNW;
	
	
	struct TBBUTTON
	{
		int iBitmap;
		int idCommand;
		BYTE fsState;
		BYTE fsStyle;
		BYTE[2] bReserved;
		DWORD dwData;
		int iString;
	}
	alias TBBUTTON* PTBBUTTON, LPTBBUTTON, LPCTBBUTTON;
	
	
	struct NMTOOLBARA
	{
		NMHDR hdr;
		int iItem;
		TBBUTTON tbButton;
		int cchText;
		LPSTR pszText;
		RECT rcButton;
	}
	alias NMTOOLBARA* LPNMTOOLBARA;
	
	
	struct NMTOOLBARW
	{
		NMHDR hdr;
		int iItem;
		TBBUTTON tbButton;
		int cchText;
		LPWSTR pszText;
		RECT rcButton;
	}
	alias NMTOOLBARW* LPNMTOOLBARW;
	
	
	enum: BYTE
	{
		TBSTYLE_BUTTON = 0x00,
		TBSTYLE_SEP = 0x01,
		TBSTYLE_CHECK = 0x02,
		TBSTYLE_GROUP = 0x04,
		TBSTYLE_DROPDOWN = 0x08,
		TBSTYLE_AUTOSIZE = 0x10,
		
		/+
		// The following are too big for TBBUTTON.fsStyle
		TBSTYLE_TOOLTIPS = 0x0100,
		TBSTYLE_WRAPABLE = 0x0200,
		TBSTYLE_ALTDRAG = 0x0400,
		+/
	}
	
	
	enum: BYTE
	{
		//BTNS_AUTOSIZE = TBSTYLE_AUTOSIZE,
		
		BTNS_WHOLEDROPDOWN = 0x80,
	}
	
	
	enum: BYTE
	{
		TBSTATE_CHECKED = 0x01,
		TBSTATE_PRESSED = 0x02,
		TBSTATE_ENABLED = 0x04,
		TBSTATE_HIDDEN = 0x08,
		TBSTATE_INDETERMINATE = 0x10,
		TBSTATE_WRAP = 0x20,
		TBSTATE_ELLIPSES = 0x40,
		TBSTATE_MARKED = 0x80,
	}
	
	
	enum: LRESULT
	{
		TBDDRET_DEFAULT = 0,
		TBDDRET_NODEFAULT = 1,
		TBDDRET_TREATPRESSED = 2,
	}
	
	
	enum: UINT
	{
		TB_SETSTATE = WM_USER + 17,
		TB_ADDBUTTONSA = WM_USER + 20,
		TB_INSERTBUTTONA = WM_USER + 21,
		TB_DELETEBUTTON = WM_USER + 22,
		TB_GETITEMRECT = WM_USER + 29,
		TB_BUTTONSTRUCTSIZE = WM_USER + 30,
		TB_SETBUTTONSIZE = WM_USER + 31,
		TB_AUTOSIZE = WM_USER + 33,
		TB_SETIMAGELIST = WM_USER + 48,
		TB_INSERTBUTTONW = WM_USER + 67,
		TB_ADDBUTTONSW = WM_USER + 68,
		TB_SETPADDING = WM_USER + 87,
	}
	
	
	enum: UINT
	{
		TBN_FIRST = cast(UINT)-700,
		TBN_DROPDOWN = TBN_FIRST - 10,
	}
	
	
	struct TVITEMA
	{
		UINT mask;
		HTREEITEM hItem;
		UINT state;
		UINT stateMask;
		LPSTR pszText;
		int cchTextMax;
		int iImage;
		int iSelectedImage;
		int cChildren;
		LPARAM lParam;
	}
	alias TVITEMA* LPTVITEMA;
	alias TVITEMA* PTVITEMA;
	alias TVITEMA TV_ITEMA;
	alias TVITEMA* LPTV_ITEMA;
	alias TVITEMA* PTV_ITEMA;
	
	
	struct TVITEMW
	{
		UINT mask;
		HTREEITEM hItem;
		UINT state;
		UINT stateMask;
		LPWSTR pszText;
		int cchTextMax;
		int iImage;
		int iSelectedImage;
		int cChildren;
		LPARAM lParam;
	}
	alias TVITEMW* LPTVITEMW;
	alias TVITEMW* PTVITEMW;
	alias TVITEMW TV_ITEMW;
	alias TVITEMW* LPTV_ITEMW;
	alias TVITEMW* PTV_ITEMW;
	
	
	struct TVHITTESTINFO
	{
		POINT pt;
		UINT flags;
		HTREEITEM hItem;
	}
	alias TVHITTESTINFO* LPTVHITTESTINFO;
	
	
	struct TVINSERTSTRUCTA
	{
		HTREEITEM hParent;
		HTREEITEM hInsertAfter;
		TV_ITEMA item;
	}
	alias TVINSERTSTRUCTA* LPTVINSERTSTRUCTA;
	alias TVINSERTSTRUCTA TV_INSERTSTRUCTA;
	alias TVINSERTSTRUCTA* LPTV_INSERTSTRUCTA;
	
	
	struct NMTREEVIEWA
	{
		NMHDR hdr;
		UINT action;
		TVITEMA itemOld;
		TVITEMA itemNew;
		POINT ptDrag;
	}
	alias NMTREEVIEWA* LPNMTREEVIEWA;
	alias NMTREEVIEWA NM_TREEVIEW;
	alias NMTREEVIEWA* LPNM_TREEVIEW;
	
	
	struct NMTVDISPINFOA
	{
		NMHDR hdr;
		TVITEMA item;
	}
	alias NMTVDISPINFOA* LPNMTVDISPINFOA;
	alias NMTVDISPINFOA TV_DISPINFOA;
	alias NMTVDISPINFOA* LPTV_DISPINFOA;
	
	
	struct NMTVDISPINFOW
	{
		NMHDR hdr;
		TVITEMW item;
	}
	alias NMTVDISPINFOW* LPNMTVDISPINFOW;
	alias NMTVDISPINFOW TV_DISPINFOW;
	alias NMTVDISPINFOW* LPTV_DISPINFOW;
	
	
	struct TCITEMA
	{
		UINT mask;
		UINT lpReserved1;
		UINT lpReserved2;
		LPSTR pszText;
		int cchTextMax;
		int iImage;
		LPARAM lParam;
	}
	alias TCITEMA* LPTCITEMA;
	alias TCITEMA TC_ITEMA;
	alias TCITEMA* LPTC_ITEMA;
	
	
	struct TCITEMW
	{
		UINT mask;
		UINT lpReserved1;
		UINT lpReserved2;
		LPWSTR pszText;
		int cchTextMax;
		int iImage;
		LPARAM lParam;
	}
	alias TCITEMW* LPTCITEMW;
	alias TCITEMW TC_ITEMW;
	alias TCITEMW* LPTC_ITEMW;
	
	
	// Rich edit.
	struct CHARRANGE
	{
		LONG cpMin; 
		LONG cpMax; 
	}
	
	
	// Rich edit.
	struct EDITSTREAM
	{
		/+ DWORD_PTR +/ DWORD dwCookie;
		DWORD dwError;
		EDITSTREAMCALLBACK pfnCallback;
	}
	
	
	// Rich edit.
	struct CHARFORMAT2A
	{
		UINT cbSize;
		DWORD dwMask;
		DWORD dwEffects;
		LONG yHeight;
		LONG yOffset;
		COLORREF crTextColor;
		BYTE bCharSet;
		BYTE bPitchAndFamily;
		char[LF_FACESIZE] szFaceName;
		WORD wWeight;
		SHORT sSpacing;
		COLORREF crBackColor;
		LCID lcid;
		DWORD dwReserved;
		SHORT sStyle;
		WORD wKerning;
		BYTE bUnderlineType;
		BYTE bAnimation;
		BYTE bRevAuthor;
		BYTE bReserved1;
	}
	static assert(CHARFORMAT2A.sizeof == 84);
	
	
	// Rich edit.
	struct ENLINK
	{
		NMHDR nmhdr;
		UINT msg;
		WPARAM wParam;
		LPARAM lParam;
		CHARRANGE chrg;
	}
	
	
	struct TEXTRANGEA
	{
		CHARRANGE chrg;
		LPSTR lpstrText;
	}
	
	
	struct MENUITEMINFOA
	{
		UINT cbSize;
		UINT fMask;
		UINT fType;
		UINT fState;
		UINT wID;
		HMENU hSubMenu;
		HBITMAP hbmpChecked;
		HBITMAP hbmpUnchecked;
		DWORD dwItemData;
		LPSTR dwTypeData;
		UINT cch;
		//HBITMAP hbmpItem;
	}
	alias MENUITEMINFOA* LPMENUITEMINFOA;
	
	
	struct MENUITEMINFOW
	{
		UINT cbSize;
		UINT fMask;
		UINT fType;
		UINT fState;
		UINT wID;
		HMENU hSubMenu;
		HBITMAP hbmpChecked;
		HBITMAP hbmpUnchecked;
		DWORD dwItemData;
		LPWSTR dwTypeData;
		UINT cch;
		//HBITMAP hbmpItem;
	}
	alias MENUITEMINFOW* LPMENUITEMINFOW;
	
	
	struct SCROLLINFO
	{
		UINT cbSize;
		UINT fMask;
		int nMin;
		int nMax;
		UINT nPage;
		int nPos;
		int nTrackPos;
	}
	alias SCROLLINFO* LPSCROLLINFO;
	
	
	struct OPENFILENAMEW
	{
		DWORD lStructSize;
		HWND hwndOwner;
		HINSTANCE hInstance;
		LPCWSTR lpstrFilter;
		LPWSTR lpstrCustomFilter;
		DWORD nMaxCustFilter;
		DWORD nFilterIndex;
		LPWSTR lpstrFile;
		DWORD nMaxFile;
		LPWSTR lpstrFileTitle;
		DWORD nMaxFileTitle;
		LPCWSTR lpstrInitialDir;
		LPCWSTR lpstrTitle;
		DWORD Flags;
		WORD nFileOffset;
		WORD nFileExtension;
		LPCWSTR lpstrDefExt;
		LPARAM lCustData;
		LPOFNHOOKPROC lpfnHook;
		LPCWSTR lpTemplateName;
	}
	alias OPENFILENAMEW* LPOPENFILENAMEW;
	
	
	alias UINT function(HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam) LPCCHOOKPROC;
	
	
	alias UINT function(HWND hdlg, UINT uiMsg, WPARAM wParam, LPARAM lParam) LPCFHOOKPROC;
	
	
	alias BOOL function(HDC hdc, LPARAM lpData, int cchData) GRAYSTRINGPROC;
	
	
	enum: DWORD
	{
		CC_RGBINIT = 0x00000001,
		CC_FULLOPEN = 0x00000002,
		CC_PREVENTFULLOPEN = 0x00000004,
		CC_SHOWHELP = 0x00000008,
		CC_ENABLEHOOK = 0x00000010,
		CC_ENABLETEMPLATE = 0x00000020,
		CC_ENABLETEMPLATEHANDLE = 0x00000040,
		CC_SOLIDCOLOR = 0x00000080,
		CC_ANYCOLOR = 0x00000100,
	}
	
	
	struct CHOOSECOLORA
	{
		DWORD lStructSize; 
		HWND hwndOwner; 
		HWND hInstance; 
		COLORREF rgbResult; 
		COLORREF* lpCustColors; 
		DWORD Flags; 
		LPARAM lCustData; 
		LPCCHOOKPROC lpfnHook; 
		LPCSTR lpTemplateName; 
	}
	alias CHOOSECOLORA* PCHOOSECOLORA;
	alias CHOOSECOLORA* LPCHOOSECOLORA;
	
	
	struct LOGFONTW
	{
		LONG lfHeight;
		LONG lfWidth;
		LONG lfEscapement;
		LONG lfOrientation;
		LONG lfWeight;
		BYTE lfItalic;
		BYTE lfUnderline;
		BYTE lfStrikeOut;
		BYTE lfCharSet;
		BYTE lfOutPrecision;
		BYTE lfClipPrecision;
		BYTE lfQuality;
		BYTE lfPitchAndFamily;
		WCHAR[32] lfFaceName;
	}
	alias LOGFONTW* PLOGFONTW;
	alias LOGFONTW* LPLOGFONTW;
	
	
	struct NONCLIENTMETRICSA
	{
		UINT cbSize;
		int iBorderWidth;
		int iScrollWidth;
		int iScrollHeight;
		int iCaptionWidth;
		int iCaptionHeight;
		LOGFONTA lfCaptionFont;
		int iSmCaptionWidth;
		int iSmCaptionHeight;
		LOGFONTA lfSmCaptionFont;
		int iMenuWidth;
		int iMenuHeight;
		LOGFONTA lfMenuFont;
		LOGFONTA lfStatusFont;
		LOGFONTA lfMessageFont;
	}
	alias NONCLIENTMETRICSA LPNONCLIENTMETRICSA;
	
	
	struct CHOOSEFONTW
	{
		align(1):
		DWORD lStructSize;
		HWND hwndOwner;
		HDC hDC;
		LPLOGFONTW lpLogFont;
		INT iPointSize;
		DWORD Flags;
		DWORD rgbColors;
		LPARAM lCustData;
		LPCFHOOKPROC lpfnHook;
		LPCWSTR lpTemplateName;
		HINSTANCE hInstance;
		LPWSTR lpszStyle;
		WORD nFontType;
		WORD ___MISSING_ALIGNMENT__;
		INT nSizeMin;
		INT nSizeMax;
	}
	alias CHOOSEFONTW* PCHOOSEFONTW;
	alias CHOOSEFONTW* LPCHOOSEFONTW;
	
	
	struct CHOOSEFONTA
	{
		align(1):
		DWORD lStructSize;
		HWND hwndOwner;
		HDC hDC;
		LPLOGFONTA lpLogFont;
		INT iPointSize;
		DWORD Flags;
		DWORD rgbColors;
		LPARAM lCustData;
		LPCFHOOKPROC lpfnHook;
		LPCSTR lpTemplateName;
		HINSTANCE hInstance;
		LPSTR lpszStyle;
		WORD nFontType;
		WORD ___MISSING_ALIGNMENT__;
		INT nSizeMin;
		INT nSizeMax;
	}
	alias CHOOSEFONTA* PCHOOSEFONTA;
	alias CHOOSEFONTA* LPCHOOSEFONTA;
	
	
	struct ICONINFO
	{
		BOOL fIcon;
		DWORD xHotspot;
		DWORD yHotspot;
		HBITMAP hbmMask;
		HBITMAP hbmColor;
	}
	alias ICONINFO* LPICONINFO;
	alias ICONINFO* PICONINFO;
	
	
	struct MINMAXINFO
	{
		POINT ptReserved;
		POINT ptMaxSize;
		POINT ptMaxPosition;
		POINT ptMinTrackSize;
		POINT ptMaxTrackSize;
	}
	alias MINMAXINFO* LPMINMAXINFO;
	alias MINMAXINFO* PMINMAXINFO;
	
	
	struct NCCALCSIZE_PARAMS
	{
		RECT[3] rgrc; 
		PWINDOWPOS lppos; 
	}
	alias NCCALCSIZE_PARAMS* LPNCCALCSIZE_PARAMS;
	
	
	struct CREATESTRUCTA
	{
		LPVOID lpCreateParams;
		HINSTANCE hInstance;
		HMENU hMenu;
		HWND hwndParent;
		int cy;
		int cx;
		int y;
		int x;
		LONG style;
		LPCSTR lpszName;
		LPCSTR lpszClass;
		DWORD dwExStyle;
	}
	alias CREATESTRUCTA* LPCREATESTRUCTA;
	
	
	struct ACTCTXW
	{
		ULONG cbSize;
		DWORD dwFlags;
		LPCWSTR lpSource;
		USHORT wProcessorArchitecture;
		LANGID wLangId;
		LPCWSTR lpAssemblyDirectory;
		LPCWSTR lpResourceName;
		LPCWSTR lpApplicationName;
		HMODULE hModule;
	}
	alias ACTCTXW* PACTCTXW;
	alias ACTCTXW* LPACTCTXW;
	
	
	struct HELPINFO
	{
		UINT cbSize;
		int iContextType;
		int iCtrlId;
		HANDLE hItemHandle;
		DWORD dwContextId;
		POINT MousePos;
	}
	alias HELPINFO* LPHELPINFO;
	
	
	struct TOOLINFOA
	{
		UINT cbSize;
		UINT uFlags;
		HWND hwnd;
		UINT uId;
		RECT rect;
		HINSTANCE hinst;
		LPSTR lpszText;
	}
	alias TOOLINFOA* PTOOLINFOA;
	alias TOOLINFOA* LPTOOLINFOA;
	
	
	struct TRACKMOUSEEVENT
	{
		DWORD cbSize;
		DWORD dwFlags;
		HWND hwndTrack;
		DWORD dwHoverTime;
	}
	alias TRACKMOUSEEVENT* LPTRACKMOUSEEVENT;
	
	
	struct STYLESTRUCT
	{
		DWORD styleOld;
		DWORD styleNew;
	}
	alias STYLESTRUCT* LPSTYLESTRUCT;
	
	
	//extern(C) DWORD MAKELONG(WORD wLow, WORD wHigh)
	extern(C) DWORD MAKELONG(int wLow, int wHigh)
	{
		return cast(DWORD)cast(WORD)wLow | (cast(DWORD)cast(WORD)wHigh << 16);
	}
	
	alias MAKELONG MAKELPARAM;
	alias MAKELONG MAKEWPARAM;
	alias MAKELONG MAKELRESULT;
	
	
	const int DLGWINDOWEXTRA = 30;
	
	
	extern(C) COLORREF RGB(int r, int g , int b)
	{
		return cast(COLORREF)(cast(BYTE)r |
			cast(WORD)(cast(BYTE)g << 8) |
			cast(DWORD)(cast(BYTE)b << 16));
	}
	
	
	struct DRAWITEMSTRUCT
	{
		UINT CtlType;
		UINT CtlID;
		UINT itemID;
		UINT itemAction;
		UINT itemState;
		HWND hwndItem;
		HDC hDC;
		RECT rcItem;
		DWORD itemData;
	}
	alias DRAWITEMSTRUCT* LPDRAWITEMSTRUCT;
	
	
	struct MEASUREITEMSTRUCT
	{
		UINT CtlType;
		UINT CtlID;
		UINT itemID;
		UINT itemWidth;
		UINT itemHeight;
		DWORD itemData;
	}
	alias MEASUREITEMSTRUCT* LPMEASUREITEMSTRUCT;
	
	
	struct ANIMATIONINFO
	{
		UINT cbSize;
		int iMinAnimate;
	}
	
	
	struct APPBARDATA
	{
		DWORD cbSize;
		HWND hWnd;
		UINT uCallbackMessage;
		UINT uEdge;
		RECT rc;
		LPARAM lParam; // message specific
	}
	alias APPBARDATA* PAPPBARDATA;
	
	
	struct CLIENTCREATESTRUCT
	{
		HANDLE hWindowMenu;
		UINT idFirstChild;
	}
	alias CLIENTCREATESTRUCT* LPCLIENTCREATESTRUCT;
	
	
	struct MDICREATESTRUCTA
	{
		LPCSTR szClass;
		LPCSTR szTitle;
		HANDLE hOwner;
		int x;
		int y;
		int cx;
		int cy;
		DWORD style;
		LPARAM lParam;
	}
	alias MDICREATESTRUCTA* LPMDICREATESTRUCTA;
	
	
	struct INITCOMMONCONTROLSEX
	{
		DWORD dwSize;
		DWORD dwICC;
	}
	alias INITCOMMONCONTROLSEX* LPINITCOMMONCONTROLSEX;
	alias INITCOMMONCONTROLSEX* PINITCOMMONCONTROLSEX;
	
	
	struct DROPFILES
	{
		DWORD pFiles;
		POINT pt;
		BOOL fNC;
		BOOL fWide;
	}
	alias DROPFILES* LPDROPFILES;
	
	
	alias HANDLE HHOOK;
	alias HANDLE HTHEME;
	alias HANDLE HTREEITEM;
	alias HANDLE HDROP;
	alias HANDLE HMONITOR;
	
	
	HCURSOR CopyCursor(HCURSOR pcur)
	{
		return cast(HCURSOR)CopyIcon(cast(HICON)pcur);
	}
	
	
	alias BOOL function(HMONITOR hMonitor, HDC hdcMonitor, LPRECT lprcMonitor, LPARAM dwData) MONITORENUMPROC;
	
	
	struct MONITORINFO
	{
		DWORD cbSize;
		RECT rcMonitor;
		RECT rcWork;
		DWORD dwFlags;
	}
	alias MONITORINFO* LPMONITORINFO;
	
	
	enum: DWORD
	{
		MONITORINFOF_PRIMARY = 1,
	}
	
	
	enum: DWORD
	{
		MONITOR_DEFAULTTONULL = 0x00000000,
		MONITOR_DEFAULTTOPRIMARY = 0x00000001,
		MONITOR_DEFAULTTONEAREST = 0x00000002,
	}
	
	
	BOOL DrawIconEx(HDC hdc, int xLeft, int yTop, HICON hIcon, int cxWidth, int cyWidth, UINT istepIfAniCur, HBRUSH hbrFlickerFreeDraw, UINT diFlags);
	BOOL DrawIcon(HDC hDC, int X, int Y, HICON hIcon);
	BOOL SetWindowPos(HWND hWnd, HWND hWndInsertAfter, int X, int Y, int cx, int cy, UINT uFlags);
	HWND GetCapture();
	HWND SetCapture(HWND hWnd);
	BOOL ReleaseCapture();
	HMENU GetMenu(HWND hWnd);
	BOOL IsChild(HWND hWndParent, HWND hWnd);
	BOOL IsWindow(HWND hWnd);
	HWND CreateWindowExW(DWORD dwExStyle, LPCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
	LRESULT SendMessageW(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	int MessageBoxW(HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType);
	DWORD SetClassLongA(HWND hWnd, int nIndex, LONG dwNewLong);
	DWORD GetClassLongA(HWND hWnd, int nIndex);
	LONG SetWindowLongA(HWND hWnd, int nIndex, LONG dwNewLong);
	LONG GetWindowLongA(HWND hWnd, int nIndex);
	DWORD GetSysColor(int nIndex);
	BOOL EnableWindow(HWND hWnd, BOOL bEnable);
	BOOL IsWindowEnabled(HWND hWnd);
	COLORREF GetTextColor(HDC hdc);
	COLORREF SetTextColor(HDC hdc, COLORREF crColor);
	HWND GetWindow(HWND hWnd, UINT uCmd);
	DWORD GetWindowThreadProcessId(HWND hWnd, LPDWORD lpdwProcessId);
	SHORT GetKeyState(int nVirtKey);
	SHORT GetAsyncKeyState(int vKey);
	HWND SetParent(HWND hWndChild, HWND hWndNewParent);
	int CombineRgn(HRGN hrgnDest, HRGN hrgnSrc1, HRGN hrgnSrc2, int fnCombineMode);
	BOOL EnumWindows(WNDENUMPROC lpEnumFunc, LPARAM lParam);
	BOOL EnumChildWindows(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPARAM lParam);
	BOOL SetWindowTextA(HWND hWnd, LPCSTR lpString);
	BOOL SetWindowTextW(HWND hWnd, LPCWSTR lpString);
	int GetWindowTextLengthA(HWND hWnd);
	int GetWindowTextLengthW(HWND hWnd);
	int GetWindowTextA(HWND hWnd, LPSTR lpString, int nMaxCount);
	int GetWindowTextW(HWND hWnd, LPWSTR lpString, int nMaxCount);
	BOOL IsWindowVisible(HWND hWnd);
	BOOL WaitMessage();
	DWORD TlsAlloc();
	BOOL TlsFree(DWORD dwTlsIndex);
	LPVOID TlsGetValue(DWORD dwTlsIndex);
	BOOL TlsSetValue(DWORD dwTlsIndex, LPVOID lpTlsValue);
	BOOL BringWindowToTop(HWND hWnd);
	UINT RegisterWindowMessageA(LPCSTR lpString);
	HWND GetParent(HWND hWnd);
	HWND GetDesktopWindow();
	HWND GetNextDlgTabItem(HWND hDlg, HWND hCtl, BOOL bPrevious);
	HBRUSH CreateSolidBrush(COLORREF crColor);
	HBRUSH CreateHatchBrush(int fnStyle, COLORREF clrref);
	int GetObjectA(HGDIOBJ hgdiobj, int cbBuffer, LPVOID lpvObject);
	void InitCommonControls();
	BOOL DestroyWindow(HWND hwnd);
	ATOM RegisterClassExA(WNDCLASSEXA* lpwcx);
	ATOM RegisterClassW(WNDCLASSW* lpWndClass);
	HWND GetActiveWindow();
	LRESULT DefDlgProcA(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam);
	LRESULT DefDlgProcW(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam);
	BOOL IsDialogMessageA(HWND hDlg, LPMSG lpMsg);
	BOOL IsDialogMessageW(HWND hDlg, LPMSG lpMsg);
	HBRUSH GetSysColorBrush(int nIndex);
	BOOL PostMessageA(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	UINT SetTimer(HWND hWnd, UINT nIDEvent, UINT uElapse, TIMERPROC lpTimerFunc);
	BOOL KillTimer(HWND hWnd, UINT uIDEvent);
	LPSTR GetCommandLineA();
	LPWSTR GetCommandLineW();
	BOOL SetCurrentDirectoryW(LPCWSTR lpPathName);
	DWORD GetCurrentDirectoryW(DWORD nBufferLength, LPWSTR lpBuffer);
	BOOL GetComputerNameA(LPSTR lpBuffer, LPDWORD nSize);
	BOOL GetComputerNameW(LPWSTR lpBuffer, LPDWORD nSize);
	BOOL GetVersionExA(LPOSVERSIONINFOA lpVersionInformation);
	UINT GetSystemDirectoryA(LPSTR lpBuffer, UINT uSize);
	UINT GetSystemDirectoryW(LPWSTR lpBuffer, UINT uSize);
	BOOL GetUserNameA(LPSTR lpBuffer, LPDWORD nSize); // advapi32.lib
	BOOL GetUserNameW(LPWSTR lpBuffer, LPDWORD nSize); // advapi32.lib
	DWORD GetEnvironmentVariableA(LPCSTR lpName, LPSTR lpBuffer, DWORD nSize);
	DWORD GetEnvironmentVariableW(LPCWSTR lpName, LPWSTR lpBuffer, DWORD nSize);
	DWORD ExpandEnvironmentStringsW(LPCWSTR lpSrc, LPWSTR lpDst, DWORD nSize);
	DWORD GetLogicalDrives();
	BOOL SetMenu(HWND hWnd, HMENU hMenu);
	BOOL SetLayeredWindowAttributes(HWND hwnd, COLORREF crKey, BYTE bAlpha, DWORD dwFlags);
	BOOL SystemParametersInfoA(UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
	BOOL TrackMouseEvent(LPTRACKMOUSEEVENT lpEventTrack);
	BOOL GetClassInfoA(HINSTANCE hInstance, LPCSTR lpClassName, LPWNDCLASSA lpWndClass);
	BOOL GetClassInfoW(HINSTANCE hInstance, LPCWSTR lpClassName, LPWNDCLASSW lpWndClass);
	LRESULT CallWindowProcA(WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	LRESULT CallWindowProcW(WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	BOOL OpenClipboard(HWND hWndNewOwner);
	BOOL EmptyClipboard();
	HGLOBAL GlobalAlloc(UINT uFlags, DWORD dwBytes);
	BOOL CloseClipboard();
	HANDLE SetClipboardData(UINT uFormat, HANDLE hMem);
	HANDLE GetClipboardData(UINT uFormat);
	HGLOBAL GlobalFree(HGLOBAL hMem);
	LPVOID GlobalLock(HGLOBAL hMem);
	BOOL GlobalUnlock(HGLOBAL hMem);
	BOOL DrawFocusRect(HDC hDC, RECT* lprc);
	LRESULT CallNextHookEx(HHOOK hhk, int nCode, WPARAM wParam, LPARAM lParam);
	HHOOK SetWindowsHookExA(int idHook, HOOKPROC lpfn, HINSTANCE hMod, DWORD dwThreadId);
	BOOL UnhookWindowsHookEx(HHOOK hhk);
	int GetSystemMetrics(int nIndex);
	BOOL DestroyMenu(HMENU hMenu);
	BOOL SetMenuItemInfoA(HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
	BOOL SetMenuItemInfoW(HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
	BOOL InsertMenuItemA(HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
	BOOL InsertMenuItemW(HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
	BOOL RemoveMenu(HMENU hMenu, UINT uPosition, UINT uFlags );
	UINT GetMenuItemID(HMENU hMenu, int nPos);
	BOOL DrawMenuBar(HWND hWnd);
	HMENU CreatePopupMenu();
	HMENU CreateMenu();
	BOOL Shell_NotifyIconA(DWORD dwMessage, NOTIFYICONDATA* pnid);
	LONG RegQueryValueExA(HKEY hKey, LPCSTR lpValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
	LONG RegQueryValueExW(HKEY hKey, LPCWSTR lpValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
	LONG RegConnectRegistryA(LPCSTR lpMachineName, HKEY hKey, PHKEY phkResult);
	UINT RegisterClipboardFormatA(LPCSTR lpszFormat);
	UINT RegisterClipboardFormatW(LPCWSTR lpszFormat);
	int GetClipboardFormatNameA(UINT format, LPSTR lpszFormatName, int cchMaxCount);
	int GetClipboardFormatNameW(UINT format, LPWSTR lpszFormatName, int cchMaxCount);
	DWORD GlobalSize(HGLOBAL hMem);
	VOID ExitProcess(UINT uExitCode);
	BOOL DrawAnimatedRects(HWND hwnd, int idAni, RECT* lprcFrom, RECT* lprcTo);
	HWND FindWindowExA(HWND hwndParent, HWND hwndChildAfter, LPCSTR lpszClass, LPCSTR lpszWindow);
	UINT SHAppBarMessage(DWORD dwMessage, PAPPBARDATA pData);
	BOOL SetPropA(HWND hWnd, LPCSTR lpString, HANDLE hData);
	HANDLE GetPropA(HWND hWnd, LPCSTR lpString);
	HANDLE RemovePropA(HWND hWnd, LPCSTR lpString);
	DWORD CommDlgExtendedError();
	LRESULT DefFrameProcA(HWND hWnd, HWND hWndMDIClient, UINT uMsg, WPARAM wParam, LPARAM lParam);
	LRESULT DefFrameProcW(HWND hWnd, HWND hWndMDIClient, UINT uMsg, WPARAM wParam, LPARAM lParam);
	LRESULT DefMDIChildProcA(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	LRESULT DefMDIChildProcW(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	VOID SetLastError(DWORD dwErrCode);
	HWND CreateMDIWindowA(LPSTR lpClassName, LPSTR lpWindowName, DWORD dwStyle, int X, int Y, int nWidth, int nHeight, HWND hWndParent, HINSTANCE hInstance, LPARAM lParam);
	int MulDiv(int nNumber, int nNumerator, int nDenominator);
	BOOL FillRgn(HDC hdc, HRGN hrgn, HBRUSH hbr);
	COLORREF GetNearestColor(HDC hdc,COLORREF crColor);
	int DrawTextA(HDC hDC, LPCSTR lpString, int nCount, LPRECT lpRect, UINT uFormat);
	int DrawTextExA(HDC hdc, LPSTR lpchText, int cchText, LPRECT lprc, UINT dwDTFormat, LPDRAWTEXTPARAMS lpDTParams);
	int DrawTextExW(HDC hdc, LPWSTR lpchText, int cchText, LPRECT lprc, UINT dwDTFormat, LPDRAWTEXTPARAMS lpDTParams);
	HANDLE LoadImageA(HINSTANCE hinst, LPCSTR lpszName, UINT uType, int cxDesired, int cyDesired, UINT fuLoad);
	HANDLE LoadImageW(HINSTANCE hinst, LPCWSTR lpszName, UINT uType, int cxDesired, int cyDesired, UINT fuLoad);
	HANDLE CopyImage(HANDLE hImage, UINT uType, int cxDesired, int cyDesired, UINT fuFlags);
	int WSACancelAsyncRequest(HANDLE hAsyncTaskHandle);
	HANDLE WSAAsyncGetHostByName(HWND hWnd, uint wMsg, PCSTR name, char* buf, int buflen);
	HANDLE WSAAsyncGetHostByAddr(HWND hWnd, uint wMsg, PCSTR addr, int len, int type, char* buf, int buflen);
	BOOL ExtTextOutA(HDC hdc, int X, int Y, UINT fuOptions, RECT* lprc, LPCSTR lpString, UINT cbCount, INT* lpDx);
	BOOL Arc(HDC hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nXStartArc, int nYStartArc, int nXEndArc, int nYEndArc);
	BOOL PolyBezier(HDC hdc, POINT* lppt,DWORD cPoints);
	BOOL Ellipse(HDC hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
	BOOL Polygon(HDC hdc, POINT* lpPoints,int nCount);
	BOOL Rectangle(HDC hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
	BOOL GdiFlush();
	LONG RegSetValueExW(HKEY hKey, LPCWSTR lpValueName, DWORD Reserved, DWORD dwType, BYTE* lpData, DWORD cbData);
	LONG RegCreateKeyExW(HKEY hKey, LPCWSTR lpSubKey, DWORD Reserved, LPWSTR lpClass, DWORD dwOptions, REGSAM samDesired, LPSECURITY_ATTRIBUTES lpSecurityAttributes, PHKEY phkResult, LPDWORD lpdwDisposition);
	LONG RegOpenKeyExW(HKEY hKey, LPCWSTR lpSubKey, DWORD ulOptions, REGSAM samDesired, PHKEY phkResult);
	LONG RegDeleteKeyW(HKEY hKey, LPCWSTR lpSubKey);
	LONG RegEnumKeyExW(HKEY hKey, DWORD dwIndex, LPWSTR lpName, LPDWORD lpcbName, LPDWORD lpReserved, LPWSTR lpClass, LPDWORD lpcbClass, PFILETIME lpftLastWriteTime);
	LONG RegEnumValueW(HKEY hKey, DWORD dwIndex, LPTSTR lpValueName, LPDWORD lpcbValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
	BOOL DrawFrameControl(HDC hdc, LPRECT lprc, UINT uType, UINT uState);
	BOOL GetTextExtentPoint32A(HDC hdc, LPCSTR lpString, int cbString, LPSIZE lpSize);
	BOOL GetTextExtentPoint32W(HDC hdc, LPCWSTR lpString, int cbString, LPSIZE lpSize);
	HINSTANCE ShellExecuteA(HWND hwnd, LPCSTR lpOperation, LPCSTR lpFile, LPCSTR lpParameters, LPCSTR lpDirectory, INT nShowCmd);
	HANDLE CreateActCtxW(PACTCTXW pActCtx);
	BOOL ActivateActCtx(HANDLE hActCtx, ULONG** lpCookie);
	UINT GetTempFileNameW(LPCWSTR lpPathName, LPCWSTR lpPrefixString, UINT uUnique, LPWSTR lpTempFileName);
	DWORD GetTempPathW(DWORD nBufferLength, LPWSTR lpBuffer);
	VOID OutputDebugStringA(LPCSTR lpOutputString);
	VOID DebugBreak();
	BOOL BitBlt(HDC hdcDest, int nXDest,int nYDest, int nWidth, int nHeight, HDC hdcSrc, int nXSrc, int nYSrc, DWORD dwRop);
	BOOL GetIconInfo(HICON hIcon, PICONINFO piconinfo);
	BOOL DestroyIcon(HICON hIcon);
	BOOL DestroyCursor(HCURSOR hCursor);
	LPITEMIDLIST SHBrowseForFolderA(LPBROWSEINFOA lpbi);
	LPITEMIDLIST SHBrowseForFolderW(LPBROWSEINFOW lpbi);
	HRESULT SHGetMalloc(LPMALLOC* ppMalloc);
	BOOL SHGetPathFromIDListA(LPCITEMIDLIST pidl, LPSTR pszPath);
	BOOL SHGetPathFromIDListW(LPCITEMIDLIST pidl, LPWSTR pszPath);
	BOOL InitCommonControlsEx(LPINITCOMMONCONTROLSEX lpInitCtrls);
	int GetDlgCtrlID(HWND hwndCtl);
	HWND GetDlgItem(HWND hDlg, int nIDDlgItem);
	BOOL ShowOwnedPopups(HWND hWnd, BOOL fShow);
	UINT GetWindowsDirectoryA(LPSTR lpBuffer, UINT uSize);
	UINT GetWindowsDirectoryW(LPWSTR lpBuffer, UINT uSize);
	//HCURSOR CopyCursor(HCURSOR pcur);
	HINSTANCE LoadLibraryExA(LPCSTR lpLibFileName, HANDLE hFile, DWORD dwFlags);
	HINSTANCE LoadLibraryExW(LPCWSTR lpLibFileName, HANDLE hFile, DWORD dwFlags);
	HICON CopyIcon(HICON hIcon);
	BOOL ChooseColorA(LPCHOOSECOLORA lpcc);
	UINT DragQueryFileA(HDROP hDrop, UINT iFile, LPSTR lpszFile, UINT cch);
	UINT DragQueryFileW(HDROP hDrop, UINT iFile, LPWSTR lpszFile, UINT cch);
	VOID DragFinish(HDROP hDrop);
	BOOL DragQueryPoint(HDROP hDrop, LPPOINT lppt);
	BOOL GrayStringA(HDC hDC, HBRUSH hBrush, GRAYSTRINGPROC lpOutputFunc, LPARAM lpData, int nCount, int X, int Y, int nWidth, int nHeight);
	BOOL IsWindowUnicode(HWND hWnd);
	BOOL ChooseFontA(LPCHOOSEFONTA lpcf);
	BOOL ChooseFontW(LPCHOOSEFONTW lpcf);
	HBITMAP CreateCompatibleBitmap(HDC hdc, int nWidth, int nHeight);
	LONG DispatchMessageW(MSG* lpmsg);
	BOOL PeekMessageW(LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);
	LRESULT DefWindowProcW(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
	HWND GetNextDlgGroupItem(HWND hDlg, HWND hCtl, BOOL bPrevious);	
	HANDLE FindFirstChangeNotificationA(LPCSTR lpPathName, BOOL bWatchSubtree, DWORD dwNotifyFilter);
	HANDLE FindFirstChangeNotificationW(LPCWSTR lpPathName, BOOL bWatchSubtree, DWORD dwNotifyFilter);
	BOOL FindCloseChangeNotification(HANDLE hChangeHandle);
	BOOL FindNextChangeNotification(HANDLE hChangeHandle);
	DWORD GetFullPathNameA(LPCSTR lpFileName, DWORD nBufferLength, LPSTR lpBuffer, LPSTR *lpFilePart);
	DWORD GetFullPathNameW(LPCWSTR lpFileName, DWORD nBufferLength, LPWSTR lpBuffer, LPWSTR *lpFilePart);
	SHORT VkKeyScanA(char ch);
	SHORT VkKeyScanW(wchar ch);
	HRSRC FindResourceExA(HMODULE hModule, LPCSTR lpType, LPCSTR lpName, WORD wLanguage);
	HRSRC FindResourceExW(HMODULE hModule, LPCWSTR lpType, LPCWSTR lpName, WORD wLanguage);
	HGLOBAL LoadResource(HMODULE hModule, HRSRC hResInfo);
	DWORD SizeofResource(HMODULE hModule, HRSRC hResInfo);
	BOOL EnableMenuItem(HMENU hMenu, UINT uIDEnableItem, UINT uEnable);
	BOOL IsMenu(HMENU hMenu);
	HMENU GetSystemMenu(HWND hWnd, BOOL bRevert);
	DWORD GetModuleFileNameW(HMODULE hModule, LPWSTR lpFilename, DWORD nSize);
	HBITMAP CreateBitmap(int nWidth, int nHeight, UINT cPlanes, UINT cBitsPerPel, VOID *lpvBits);
	BOOL SetBrushOrgEx(HDC hdc, int nXOrg, int nYOrg, LPPOINT lppt);
	BOOL PatBlt(HDC hdc, int nXLeft, int nYLeft, int nWidth, int nHeight, DWORD dwRop);
	HTHEME GetWindowTheme(HWND hWnd);
	THEMEAPI SetWindowTheme(HWND hwnd, LPCWSTR pszSubAppName, LPCWSTR pszSubIdList);
	int SetScrollInfo(HWND hwnd, int fnBar, LPSCROLLINFO lpsi, BOOL fRedraw);
	BOOL GetScrollInfo(HWND hwnd, int fnBar, LPSCROLLINFO lpsi);
	BOOL DragDetect(HWND hwnd, POINT pt);
	HFONT CreateFontIndirectW(LOGFONTW *lplf);
	DWORD GetThemeAppProperties();
	BOOL IsAppThemed();
	HTHEME OpenThemeData(HWND hwnd, LPCWSTR pszClassList);
	HRESULT CloseThemeData(HTHEME hTheme);
	HRESULT GetThemeColor(HTHEME hTheme, int iPartId, int iStateId, int iPropId, COLORREF *pColor);
	HIMAGELIST ImageList_Create(int cx, int cy, UINT flags, int cInitial, int cGrow);
	BOOL ImageList_Destroy(HIMAGELIST himl);	
	BOOL ImageList_Draw(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, UINT fStyle);
	BOOL ImageList_DrawEx(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, int dx, int dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle);
	int ImageList_Add(HIMAGELIST himl, HBITMAP hbmImage, HBITMAP hbmMask);
	int ImageList_AddIcon(HIMAGELIST himl, HICON hicon);
	int ImageList_AddMasked(HIMAGELIST himl, HBITMAP hbmImage, COLORREF crMask);
	BOOL ImageList_Remove(HIMAGELIST himl, int i);
	BOOL EnumDisplayMonitors(HDC hdc, LPCRECT lprcClip, MONITORENUMPROC lpfnEnum, LPARAM dwData);
	BOOL GetMonitorInfoA(HMONITOR hMonitor, LPMONITORINFO lpmi);
	HMONITOR MonitorFromWindow(HWND hwnd, DWORD dwFlags);
	HMONITOR MonitorFromPoint(POINT pt, DWORD dwFlags);
	HMONITOR MonitorFromRect(LPCRECT lprc, DWORD dwFlags);

//} // Temporary.

